/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.utils;

import com.sap.cds.ql.cqn.Path;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsDefinition;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.impl.utils.CdsModelUtils;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.model.CdsAnnotations;

public class ValidatorErrorUtils {
    private ValidatorErrorUtils() {
    }

    public static void handleValidationError(EventContext context, Path path, CdsElement element, CdsAnnotations messageAnnotation, CdsErrorStatuses status, Object ... args) {
        ValidatorErrorUtils.handleValidationError(context, false, path, element, messageAnnotation, status, args);
    }

    public static void handleValidationError(EventContext context, boolean forceException, Path path, CdsElement element, CdsAnnotations messageAnnotation, CdsErrorStatuses status, Object ... args) {
        boolean isTransition = CdsModelUtils.isInternalOperationType(element.getDeclaringType().as(CdsDefinition.class));
        if (forceException || !context.getCdsRuntime().getEnvironment().getCdsProperties().getErrors().isCombined()) {
            throw new ErrorStatusException((ErrorStatus)status, args).messageTarget(path, element).transition(isTransition);
        }
        context.getMessages().error(ValidatorErrorUtils.getMessageKey(messageAnnotation, element, status), args).code(status.getCodeString()).target(path, element).transition(isTransition);
    }

    public static String getMessageKey(CdsAnnotations messageAnnotation, CdsElement element, CdsErrorStatuses status) {
        String customMessage;
        String messageKey = status.getCodeString();
        if (messageAnnotation != null && (customMessage = (String)messageAnnotation.getOrDefault((CdsAnnotatable)element)) != null) {
            if (customMessage.startsWith("{i18n>")) {
                int end = customMessage.lastIndexOf(125);
                if (end >= 6) {
                    messageKey = customMessage.substring(6, end);
                }
            } else {
                messageKey = customMessage;
            }
        }
        return messageKey;
    }
}

