/*
 * © 2023-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.impl.auditlog;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.auditlog.AuditLogService;
import com.sap.cds.services.auditlog.SecurityLog;
import com.sap.cds.services.auditlog.SecurityLogContext;
import com.sap.cds.services.impl.EventContextDelegator;
import java.time.Instant;

public class SecurityLogContextImpl extends EventContextDelegator implements SecurityLogContext {
  private static final String PARAM_DATA = "data";
  private static final String PARAM_CREATED_AT = "createdAt";

  public SecurityLogContextImpl(EventContext eventContext) {
    super(eventContext);
  }

  @Override
  public AuditLogService getService() {
    return (AuditLogService) super.getService();
  }

  public SecurityLog getData() {
    return (SecurityLog) get(PARAM_DATA);
  }

  public void setData(SecurityLog event) {
    put(PARAM_DATA, event);
  }

  public Instant getCreatedAt() {
    return (Instant) get(PARAM_CREATED_AT);
  }

  public void setCreatedAt(Instant createdAt) {
    put(PARAM_CREATED_AT, createdAt);
  }
}
