/*
 * © 2023-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.impl.auditlog.events;

import com.sap.cds.Struct;
import com.sap.cds.ql.CdsName;
import com.sap.cds.services.runtime.CdsRuntime;

@CdsName("com.sap.auditlog.events.TenantOffboarded")
public interface TenantOffboardedEvent extends AuditEvent {

  Event getEvent();

  void setEvent(Event event);

  TenantEventData getData();

  void setData(TenantEventData data);

  static TenantOffboardedEvent create(String tenantId, CdsRuntime runtime) {
    TenantOffboardedEvent offboarded =
        Struct.access(AuditEvent.create(runtime)).as(TenantOffboardedEvent.class);

    TenantEventData data = TenantEventData.create();
    data.setMessageId("TENANT_OFFBOARDING");
    data.setMessage("Tenant has been offboarded.");
    data.setTenantId(tenantId);
    offboarded.setData(data);
    return offboarded;
  }
}
