/*
 * © 2020-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.impl.cds;

import com.sap.cds.services.runtime.CdsRuntimeConfiguration;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;

public class RemoteServiceConfiguration implements CdsRuntimeConfiguration {

  @Override
  public void services(CdsRuntimeConfigurer configurer) {
    // remote service have to be specified in configuration
    configurer
        .getCdsRuntime()
        .getEnvironment()
        .getCdsProperties()
        .getRemote()
        .getServices()
        .values()
        .stream()
        .map(config -> new RemoteServiceImpl(config, configurer.getCdsRuntime()))
        .forEach(configurer::service);
  }
}
