/*
 * © 2019-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.impl.draft;

import com.sap.cds.Result;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.draft.DraftGcEventContext;
import com.sap.cds.services.draft.DraftService;
import com.sap.cds.services.impl.EventContextDelegator;
import com.sap.cds.services.utils.ResultUtils;

/** Implementation of the {@link EventContext} for the {@link DraftService#EVENT_DRAFT_GC} event. */
public class DraftGcEventContextImpl extends EventContextDelegator implements DraftGcEventContext {

  public DraftGcEventContextImpl(EventContext eventContext) {
    super(eventContext);
  }

  @Override
  public DraftService getService() {
    return (DraftService) super.getService();
  }

  private static final String PARAM_RESULT = "result";

  // OUT
  /**
   * @return the {@link Result} of the {@link DraftService#EVENT_DRAFT_GC} event
   */
  public Result getResult() {
    return (Result) get(PARAM_RESULT);
  }

  /**
   * Sets the result of the {@link DraftService#EVENT_DRAFT_GC} event
   *
   * @param result a {@link Result} or a list of Maps, which will be transformed into a {@link
   *     Result}
   */
  public void setResult(Result result) {
    put(PARAM_RESULT, ResultUtils.convert(result));
    setCompleted();
  }
}
