/*
 * © 2023-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.impl.draft;

import com.sap.cds.Result;
import com.sap.cds.ResultBuilder;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.reflect.CdsService;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.draft.DraftService;
import com.sap.cds.services.utils.model.CdsAnnotations;
import java.util.Collections;
import java.util.stream.StreamSupport;

public class DraftHandlerUtils {

  private DraftHandlerUtils() {}

  public static Result buildNoOpResult(EventContext context) {
    CqnStatement statement = (CqnStatement) context.get("cqn");
    if (statement.isUpdate() || statement.isDelete()) {
      int batches =
          (int)
              StreamSupport.stream(((Iterable<?>) context.get("cqnValueSets")).spliterator(), false)
                  .count();
      // The result for the draft must have at least one batch
      return ResultBuilder.deletedRows(new long[Math.max(1, batches)])
          .rowType(context.getTarget())
          .result();
    }
    long inlineCount = statement.asSelect().hasInlineCount() ? 0 : -1;
    return ResultBuilder.selectedRows(Collections.emptyList())
        .inlineCount(inlineCount)
        .rowType(context.getTarget())
        .result();
  }

  public static String getDraftPersistenceMode(EventContext context) {
    CdsService service = ((DraftService) context.getService()).getDefinition();
    String configured =
        context.getCdsRuntime().getEnvironment().getCdsProperties().getDrafts().getPersistence();
    return CdsAnnotations.DRAFT_PERSISTENCE_ANNOTATION.getOrValue(service, configured);
  }
}
