/*
 * © 2019-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.impl.draft;

import com.sap.cds.Result;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.draft.DraftPatchEventContext;
import com.sap.cds.services.draft.DraftService;
import com.sap.cds.services.impl.EventContextDelegator;
import com.sap.cds.services.utils.ResultUtils;
import java.util.Map;

/**
 * Implementation of the {@link EventContext} for the {@link DraftService#EVENT_DRAFT_PATCH} event.
 */
public class DraftPatchEventContextImpl extends EventContextDelegator
    implements DraftPatchEventContext {

  public DraftPatchEventContextImpl(EventContext eventContext) {
    super(eventContext);
  }

  @Override
  public DraftService getService() {
    return (DraftService) super.getService();
  }

  private static final String PARAM_CQN = "cqn";
  private static final String PARAM_CQN_VALUE_SETS = "cqnValueSets";
  private static final String PARAM_RESULT = "result";

  // IN
  /**
   * @return the {@link CqnUpdate} statement
   */
  public CqnUpdate getCqn() {
    return (CqnUpdate) get(PARAM_CQN);
  }

  /**
   * Sets the {@link CqnUpdate} statement
   *
   * @param cqn the {@link CqnUpdate} statement
   */
  public void setCqn(CqnUpdate cqn) {
    put(PARAM_CQN, cqn);
  }

  /**
   * @return the CQN value sets, to enable batched {@link CqnUpdate} statements
   */
  @SuppressWarnings("unchecked")
  public Iterable<Map<String, Object>> getCqnValueSets() {
    return (Iterable<Map<String, Object>>) get(PARAM_CQN_VALUE_SETS);
  }

  /**
   * Sets the CQN value sets, to enable batched {@link CqnUpdate} statements
   *
   * @param valueSets the CQN value sets
   */
  public void setCqnValueSets(Iterable<Map<String, Object>> valueSets) {
    put(PARAM_CQN_VALUE_SETS, valueSets);
  }

  // OUT
  /**
   * @return the {@link Result} of the {@link DraftService#EVENT_DRAFT_PATCH} event
   */
  public Result getResult() {
    return (Result) get(PARAM_RESULT);
  }

  /**
   * Sets the result of the {@link DraftService#EVENT_DRAFT_PATCH} event
   *
   * @param result a {@link Result} or a list of Maps, which will be transformed into a {@link
   *     Result}
   */
  public void setResult(Iterable<? extends Map<String, ?>> result) {
    put(PARAM_RESULT, ResultUtils.convert(result));
    setCompleted();
  }
}
