/*
 * © 2020-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.impl.draft;

import static com.sap.cds.services.impl.cds.ApplicationServiceConfiguration.applicationServiceConfigs;

import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.draft.DraftService;
import com.sap.cds.services.runtime.CdsRuntimeConfiguration;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;
import com.sap.cds.services.utils.DraftUtils;

public class DraftServiceConfiguration implements CdsRuntimeConfiguration {

  @Override
  public int order() {
    return 50; // in between remote and application services
  }

  @Override
  public void services(CdsRuntimeConfigurer configurer) {
    CdsModel model = configurer.getCdsRuntime().getCdsModel();
    applicationServiceConfigs(
            configurer, s -> DraftUtils.isDraftEnabled(s.getQualifiedName(), model))
        .map(config -> new DraftServiceImpl(config, configurer.getCdsRuntime()))
        .forEach(configurer::service);
  }

  @Override
  public void eventHandlers(CdsRuntimeConfigurer configurer) {
    if (configurer
        .getCdsRuntime()
        .getServiceCatalog()
        .getServices(DraftService.class)
        .findAny()
        .isPresent()) {
      configurer.eventHandler(new ActiveHandler());
      configurer.eventHandler(new InactiveHandler(configurer.getCdsRuntime()));
      configurer.eventHandler(new DraftActionsHandler());
      configurer.eventHandler(new DraftGCHandler(configurer.getCdsRuntime()));
    }
  }
}
