/*
 * © 2023-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.impl.environment;

import com.sap.cds.services.environment.CdsEnvironment;
import com.sap.cds.services.utils.environment.VcapServicesParser;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import com.sap.cloud.environment.servicebinding.api.ServiceBindingAccessor;
import java.util.List;

public class DefaultEnvFileServiceBindingLoader implements ServiceBindingAccessor {

  /**
   * The configured path, passed dynamically to the implementation based on the value from {@link
   * CdsEnvironment}
   */
  static String configuredPath;

  @Override
  public List<ServiceBinding> getServiceBindings() {
    return VcapServicesParser.getServiceBindings(DefaultEnvFileUtils.getDefaultEnv(configuredPath));
  }
}
