/*
 * © 2019-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.impl.handlerregistry;

import com.sap.cds.services.handler.annotations.After;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.impl.Phase;

public class AnnotationDescriptor {

  private final Phase phase;
  private final String[] events;
  private final String[] entities;
  private final String[] serviceNames;
  private final Class<?>[] serviceTypes;

  public AnnotationDescriptor(Before before) {
    this.phase = Phase.BEFORE;
    this.events = before.event();
    this.entities = before.entity();
    this.serviceNames = before.service();
    this.serviceTypes = before.serviceType();
  }

  public AnnotationDescriptor(On on) {
    this.phase = Phase.ON;
    this.events = on.event();
    this.entities = on.entity();
    this.serviceNames = on.service();
    this.serviceTypes = on.serviceType();
  }

  public AnnotationDescriptor(After after) {
    this.phase = Phase.AFTER;
    this.events = after.event();
    this.entities = after.entity();
    this.serviceNames = after.service();
    this.serviceTypes = after.serviceType();
  }

  public Phase getPhase() {
    return phase;
  }

  public String[] getEvents() {
    return events; // NOSONAR
  }

  public String[] getEntities() {
    return entities; // NOSONAR
  }

  public String[] getServiceNames() {
    return serviceNames; // NOSONAR
  }

  public Class<?>[] getServiceTypes() {
    return serviceTypes; // NOSONAR
  }
}
