/*
 * © 2025 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.impl.handlerregistry.resolver;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.impl.handlerregistry.HandlerDescriptor;

/**
 * Handles handler methods returning instances of {@link Object}. The resolver works only for custom
 * events.
 */
public class ObjectReturnResolver implements ReturnResolver {

  private static final ObjectReturnResolver INSTANCE = new ObjectReturnResolver();

  private ObjectReturnResolver() {}

  public static ObjectReturnResolver createIfApplicable() {
    return INSTANCE;
  }

  @Override
  public void resolve(Object returnValue, EventContext context) {
    context.put("result", returnValue);
    context.setCompleted();
  }

  @Override
  public void verifyOrThrow(HandlerDescriptor descriptor) {
    // do nothing
  }
}
