/*
 * © 2025 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.impl.handlerregistry.resolver;

import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.Service;
import com.sap.cds.services.impl.handlerregistry.HandlerDescriptor;

/**
 * Handles all types of {@link CqnStatement} and {@link CqnStructuredTypeRef} based arguments in
 * handler methods
 */
public class ServiceArgumentResolver implements ArgumentResolver {

  public static ServiceArgumentResolver createIfApplicable(Class<?> type) {
    if (Service.class.isAssignableFrom(type)) {
      return new ServiceArgumentResolver(type);
    }
    return null;
  }

  private final Class<? extends Service> serviceType;

  @SuppressWarnings("unchecked")
  private ServiceArgumentResolver(Class<?> type) {
    this.serviceType = (Class<? extends Service>) type;
  }

  @Override
  public Object resolve(EventContext context) {
    return serviceType.cast(context.getService());
  }

  @Override
  public void verifyOrThrow(HandlerDescriptor descriptor) {
    // not yet validated
  }
}
