/*
 * © 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.impl.messaging.handlers;

import com.sap.cds.services.Service;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.messaging.MessagingService;
import com.sap.cds.services.outbox.OutboxMessage;
import com.sap.cds.services.outbox.OutboxMessageEventContext;
import com.sap.cds.services.outbox.OutboxService;
import java.util.Map;

@ServiceName(value = "*", type = OutboxService.class)
public class MessagingOutboxHandler implements EventHandler {

  @Before
  @SuppressWarnings("unchecked")
  void adjustMessagingContext(OutboxMessageEventContext context) {
    OutboxMessage message = context.getMessage();
    // backwards compatibility for old message formats without params
    if (Boolean.TRUE.equals(context.getIsInbound()) && message.getParams() == null) {
      Service service = context.getServiceCatalog().getService(context.getEvent());
      if (service instanceof MessagingService && message.get("data") instanceof Map data) {
        message.setParams((Map<String, Object>) data);
      }
    }
  }
}
