/*
 * © 2020-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.impl.mt;

import com.sap.cds.services.ServiceDelegator;
import com.sap.cds.services.mt.ReadProviderTenantEventContext;
import com.sap.cds.services.mt.ReadTenantsEventContext;
import com.sap.cds.services.mt.TenantInfo;
import com.sap.cds.services.mt.TenantProviderService;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class TenantProviderServiceImpl extends ServiceDelegator implements TenantProviderService {

  public TenantProviderServiceImpl(String name) {
    super(name);
  }

  @Override
  public List<TenantInfo> readTenantsInfo(Set<String> fields) {
    ReadTenantsEventContext context = ReadTenantsEventContext.create();
    context.setFields(fields);
    emit(context);
    return context.getResult();
  }

  @Override
  public List<TenantInfo> readTenantsInfo() {
    return readTenantsInfo(Collections.emptySet());
  }

  @Override
  public String readProviderTenant() {
    ReadProviderTenantEventContext context = ReadProviderTenantEventContext.create();
    emit(context);
    return context.getResult();
  }
}
