/*
 * © 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.impl.outbox.persistence;

import java.util.concurrent.atomic.AtomicLong;

public class OutboxStatistics {
  private final String tenant;

  // counters
  private final AtomicLong incomingMessages = new AtomicLong(0);
  private final AtomicLong outgoingMessages = new AtomicLong(0);

  // gauges
  private volatile long coldEntries = -1;
  private volatile long remainingEntries = -1;
  private volatile long maxStorageTime = -1;
  private volatile long medianStorageTime = -1;
  private volatile long minStorageTime = -1;

  public OutboxStatistics(String tenant) {
    this.tenant = tenant;
  }

  public String getTenant() {
    return tenant;
  }

  static Long incomingMessages(OutboxStatistics stats) {
    return stats.getIncomingMessages();
  }

  public void increaseIncomingMessages(long delta) {
    this.incomingMessages.addAndGet(delta);
  }

  public Long getIncomingMessages() {
    return this.incomingMessages.get();
  }

  static Long outgoingMessages(OutboxStatistics stats) {
    return stats.getOutgoingMessages();
  }

  public void increaseOutgoingMessages(long delta) {
    this.outgoingMessages.addAndGet(delta);
  }

  public Long getOutgoingMessages() {
    return this.outgoingMessages.get();
  }

  public long getColdEntries() {
    return coldEntries;
  }

  static Long coldEntries(OutboxStatistics stats) {
    return stats.getColdEntries();
  }

  public void setColdEntries(long coldEntries) {
    this.coldEntries = coldEntries;
  }

  public long getRemainingEntries() {
    return remainingEntries;
  }

  static Long remainingEntries(OutboxStatistics stats) {
    return stats.getRemainingEntries();
  }

  public void setRemainingEntries(long remainingEntries) {
    this.remainingEntries = remainingEntries;
  }

  public long getMaxStorageTime() {
    return maxStorageTime;
  }

  static Long maxStorageTime(OutboxStatistics stats) {
    return stats.getMaxStorageTime();
  }

  public void setMaxStorageTime(long maxStorageTime) {
    this.maxStorageTime = maxStorageTime;
  }

  public long getMedianStorageTime() {
    return medianStorageTime;
  }

  static Long medianStorageTime(OutboxStatistics stats) {
    return stats.getMedianStorageTime();
  }

  public void setMedianStorageTime(long medianStorageTime) {
    this.medianStorageTime = medianStorageTime;
  }

  public long getMinStorageTime() {
    return minStorageTime;
  }

  static Long minStorageTime(OutboxStatistics stats) {
    return stats.getMinStorageTime();
  }

  public void setMinStorageTime(long minStorageTime) {
    this.minStorageTime = minStorageTime;
  }
}
