/*
 * © 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.impl.outbox.persistence;

import com.sap.cds.services.persistence.PersistenceService;
import com.sap.cds.services.runtime.CdsRuntime;
import java.util.Collection;
import java.util.List;

public interface TelemetryData {

  public static final TelemetryData NOOP = new TelemetryData() {};

  default Collection<OutboxStatistics> getStatistics() {
    return List.of();
  }

  default void recordIncomingMessages(String tenant, long count) {
    // NOOP
  }

  default void recordOutgoingMessages(String tenant, long count) {
    // NOOP
  }

  default void recordStatistics(CdsRuntime runtime, PersistenceService db, String tenant) {
    // NOOP
  }
}
