/*
 * © 2019-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.impl.persistence;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.cds.CqnService;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.utils.NotNullValidator;
import com.sap.cds.services.persistence.PersistenceService;
import com.sap.cds.services.utils.OrderConstants;

/**
 * Handler class to check not null elements. Adding not null to an element leads to a database
 * constraint check. This handler is mainly there to improve the error message in case such an
 * element is set to null
 */
@ServiceName(value = "*", type = PersistenceService.class)
public class NotNullHandler implements EventHandler {

  @Before(event = {CqnService.EVENT_CREATE, CqnService.EVENT_UPDATE, CqnService.EVENT_UPSERT})
  @HandlerOrder(OrderConstants.Before.VALIDATE_FIELDS)
  public void runCheck(EventContext context) {
    NotNullValidator.runNotNullCheck(context, true);
  }
}
