/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.application;

import com.sap.cds.services.impl.application.CdsPropertyLoggingContext;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdsPropertiesLogger {
    private static final Logger logger = LoggerFactory.getLogger(CdsPropertiesLogger.class);

    public boolean isLoggingEnabled() {
        return logger.isWarnEnabled();
    }

    public void log(List<CdsPropertyLoggingContext> propertiesWithNonDefaultValues) {
        if (propertiesWithNonDefaultValues.isEmpty()) {
            logger.debug("All cds properties are set to default values.");
        }
        this.logProperties(propertiesWithNonDefaultValues);
    }

    private void logProperties(List<CdsPropertyLoggingContext> propertiesWithNonDefaultValues) {
        propertiesWithNonDefaultValues.stream().filter(property -> logger.isDebugEnabled() || property.isDeprecated() || !property.isDocumented()).forEach(propertyWithLoggingContext -> {
            StringBuilder message = new StringBuilder();
            Object logValue = propertyWithLoggingContext.containsSensitiveData() ? "***" : propertyWithLoggingContext.actualValue();
            message.append("'").append(propertyWithLoggingContext.propertyPath()).append("': '").append(logValue).append("'");
            ArrayList<String> warnings = new ArrayList<String>();
            if (propertyWithLoggingContext.isDeprecated()) {
                warnings.add("deprecated");
            }
            if (!propertyWithLoggingContext.isDocumented()) {
                warnings.add("not documented");
            }
            ArrayList<String> hints = new ArrayList<String>();
            if (this.logDefaultValue((CdsPropertyLoggingContext)propertyWithLoggingContext)) {
                hints.add(String.format("default: '%s'", propertyWithLoggingContext.defaultValue()));
            }
            hints.addAll(warnings);
            if (propertyWithLoggingContext.containsSensitiveData()) {
                hints.add("sensitive");
            }
            if (!hints.isEmpty()) {
                message.append(" (").append(String.join((CharSequence)", ", hints)).append(")");
            }
            if (!warnings.isEmpty()) {
                logger.warn(message.toString());
            } else {
                logger.debug(message.toString());
            }
        });
    }

    private boolean logDefaultValue(CdsPropertyLoggingContext propertyWithLoggingContext) {
        return propertyWithLoggingContext.defaultValue() != null && !propertyWithLoggingContext.defaultValue().equals("");
    }
}

