/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.authorization;

import com.sap.cds.impl.builder.model.Conjunction;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnExistsSubquery;
import com.sap.cds.ql.cqn.CqnMatchPredicate;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.util.CdsModelUtils;
import java.util.Set;

public class PathExpressionPredicateConverter {
    private static final StructuredType<?> $OUTER = CQL.to((String)"$outer");

    private PathExpressionPredicateConverter() {
    }

    public static CqnPredicate convert(CdsStructuredType target, CqnPredicate authorizationCondition) {
        return PathExpressionPredicateConverter.convert(target, null, authorizationCondition);
    }

    static CqnPredicate convert(CdsStructuredType target, CdsElement association, CqnPredicate authorizationCondition) {
        if (authorizationCondition.equals(CQL.FALSE) || authorizationCondition.asPredicate() instanceof CqnExistsSubquery) {
            return authorizationCondition;
        }
        HasRefsWithComplexPaths v = new HasRefsWithComplexPaths();
        authorizationCondition.accept((CqnVisitor)v);
        if (v.containsPaths()) {
            Set keys = association != null ? CdsModelUtils.targetKeys((CdsElement)association) : CdsModelUtils.concreteKeyNames((CdsStructuredType)target);
            CqnPredicate joinCondition = (CqnPredicate)keys.stream().map(k -> CQL.get((String)k).eq((Value)$OUTER.get(k))).collect(Conjunction.and());
            authorizationCondition = CQL.and((CqnPredicate)joinCondition, (CqnPredicate)authorizationCondition);
            return CQL.exists((CqnSelect)Select.from((String)target.getQualifiedName()).where(authorizationCondition));
        }
        return authorizationCondition;
    }

    private static class HasRefsWithComplexPaths
    implements CqnVisitor {
        private boolean hasPath = false;

        private HasRefsWithComplexPaths() {
        }

        public void visit(CqnMatchPredicate match) {
            if (!this.hasPath) {
                this.hasPath = HasRefsWithComplexPaths.isPath((CqnReference)match.ref());
            }
        }

        public void visit(CqnElementRef elementRef) {
            if (!this.hasPath) {
                this.hasPath = HasRefsWithComplexPaths.isPath((CqnReference)elementRef);
            }
        }

        private static boolean isPath(CqnReference ref) {
            return ref.size() > 1 && !"$user".equals(ref.firstSegment());
        }

        public boolean containsPaths() {
            return this.hasPath;
        }
    }
}

