/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.authorization;

import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.services.impl.authorization.PredicateResolver;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.utils.model.Privilege;
import java.util.HashMap;
import java.util.Map;

public class PredicateLookup {
    private final Map<String, PredicateResolver> cachedPredicatePatterns = new HashMap<String, PredicateResolver>();

    public CqnPredicate resolvePredicate(Privilege privilege, UserInfo user) {
        CqnPredicate pred = privilege.getWhereXpr();
        if (pred == null) {
            return null;
        }
        String cxnExpression = privilege.getCxnWhereCondition();
        PredicateResolver cachedPredicatePattern = this.cachedPredicatePatterns.get(cxnExpression);
        if (cachedPredicatePattern == null) {
            cachedPredicatePattern = PredicateResolver.create(pred);
            this.cachedPredicatePatterns.put(cxnExpression, cachedPredicatePattern);
        }
        if (cachedPredicatePattern != null) {
            return cachedPredicatePattern.resolve(user);
        }
        return null;
    }
}

