/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.cds;

import com.sap.cds.Result;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.cqn.CqnAnalyzer;
import com.sap.cds.ql.cqn.CqnFilterableStatement;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.impl.utils.CdsServiceUtils;
import com.sap.cds.services.utils.DraftUtils;
import com.sap.cds.util.DataUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;

final class QueryAuthorizationCheckHelper {
    private QueryAuthorizationCheckHelper() {
    }

    static boolean checkAccessWithSelect(EventContext context, CqnPredicate keyFilter, CqnPredicate authFilter) {
        Iterator iterator;
        Select read = Select.from((CdsEntity)context.getTarget()).columns(new Function[]{c -> CQL.val((Object)1).as("FAILED")}).where((CqnPredicate)CQL.and((CqnPredicate)keyFilter, (CqnPredicate)CQL.not((CqnPredicate)authFilter))).limit(1L);
        Iterable cqnValueSets = (Iterable)context.get("cqnValueSets");
        if (cqnValueSets != null && (iterator = cqnValueSets.iterator()).hasNext()) {
            while (iterator.hasNext()) {
                Map set = (Map)iterator.next();
                if (CdsServiceUtils.getDefaultPersistenceService(context).run((CqnSelect)read, set).rowCount() <= 0L) continue;
                return false;
            }
            return true;
        }
        return CdsServiceUtils.getDefaultPersistenceService(context).run((CqnSelect)read, new Object[0]).rowCount() == 0L;
    }

    static CqnPredicate keyFilterFromStatement(EventContext context) {
        Object object = context.get("cqn");
        if (object instanceof CqnFilterableStatement) {
            CqnFilterableStatement statement = (CqnFilterableStatement)object;
            CqnAnalyzer analyzer = CqnAnalyzer.create((CdsModel)context.getModel());
            Map targetKeys = analyzer.analyze(statement).targetKeys();
            if (QueryAuthorizationCheckHelper.hasMissingKeyValues(targetKeys)) {
                return CQL.FALSE;
            }
            if (DraftUtils.isDraftEnabled((CdsAnnotatable)context.getTarget()) && Boolean.FALSE.equals(targetKeys.get("IsActiveEntity"))) {
                return CQL.FALSE;
            }
            return CQL.matching((Map)targetKeys);
        }
        return CQL.FALSE;
    }

    static CqnPredicate keyFilterFromResult(EventContext context, Result result) {
        if (result == null || result.first().filter(e -> !e.isEmpty()).isEmpty()) {
            return CQL.FALSE;
        }
        return (CqnPredicate)result.stream().map(row -> {
            Map keyValues = DataUtils.keyValues((CdsEntity)context.getTarget(), (Map)row);
            if (QueryAuthorizationCheckHelper.hasMissingKeyValues(keyValues)) {
                return CQL.FALSE;
            }
            return CQL.matching((Map)keyValues);
        }).collect(CQL.withOr());
    }

    private static boolean hasMissingKeyValues(Map<String, Object> targetKeys) {
        return targetKeys.isEmpty() || targetKeys.containsValue(null);
    }
}

