/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.cds;

import com.sap.cds.Result;
import com.sap.cds.impl.DataProcessor;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.impl.SelectListValueBuilder;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.cds.ConstraintAssertionHandler;
import com.sap.cds.services.impl.utils.CdsServiceUtils;
import com.sap.cds.services.persistence.PersistenceService;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.TenantAwareCache;
import com.sap.cds.services.utils.model.CdsAnnotations;
import com.sap.cds.util.CdsModelUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

@ServiceName(value={"*"}, type={ApplicationService.class})
public class ReadOnlyHandler
implements EventHandler {
    private static final String READONLY_PREFIX = "@readonly_";
    private final CdsProperties cdsProperties;
    private final PersistenceService db;
    private final TenantAwareCache<Map<CdsEntity, List<CqnSelectListValue>>, CdsModel> annotationCache;

    public ReadOnlyHandler(CdsRuntime runtime) {
        this.cdsProperties = runtime.getEnvironment().getCdsProperties();
        this.db = (PersistenceService)runtime.getServiceCatalog().getService(PersistenceService.class, "PersistenceService$Default");
        this.annotationCache = TenantAwareCache.create(ConcurrentHashMap::new, (CdsRuntime)runtime);
    }

    @Before(event={"CREATE", "UPDATE", "UPSERT", "DRAFT_NEW", "DRAFT_PATCH"})
    @HandlerOrder(value=-10400)
    public void cleanReadOnlyFields(EventContext context, CqnStatement cqn) {
        boolean enforceReadonlyOnDrafts = context.getCdsRuntime().getEnvironment().getCdsProperties().getDrafts().isEnforceReadonly();
        if (!enforceReadonlyOnDrafts && context.getEvent().startsWith("DRAFT_")) {
            return;
        }
        boolean skipReadonly = Boolean.FALSE.equals(cqn.hints().get("@readonly"));
        Map annotationsPerEntity = (Map)this.annotationCache.findOrCreate();
        HashMap<CdsEntity, List> keysPerEntity = new HashMap<CdsEntity, List>();
        List<Map<String, Object>> dataList = CdsServiceUtils.getEntities(context);
        DataProcessor.create().bulkAction((type, entries) -> {
            if (type instanceof CdsEntity) {
                List readonlyExpressions;
                CdsEntity entity = (CdsEntity)type;
                if (!(cqn.isInsert() || skipReadonly || (readonlyExpressions = annotationsPerEntity.computeIfAbsent(entity, this::collectReadonlyExpressions)).isEmpty())) {
                    List keyValues = keysPerEntity.computeIfAbsent(entity, t -> new ArrayList());
                    Set keyNames = CdsModelUtils.concreteKeyNames((CdsStructuredType)type);
                    entries.forEach(entry -> ConstraintAssertionHandler.addKeysTo(keyNames, entry, keyValues));
                }
            }
            for (Map entry2 : entries) {
                type.elements().filter(element -> this.isStaticallyReadOnly((CdsElement)element, context.getEvent(), skipReadonly, entry2)).forEach(e -> entry2.remove(e.getName()));
            }
        }).process(dataList, (CdsStructuredType)context.getTarget());
        HashMap dynamicReadonlyPerEntity = new HashMap(keysPerEntity.size());
        keysPerEntity.forEach((entity, keyValues) -> {
            if (keyValues.isEmpty()) {
                return;
            }
            ArrayList selectables = new ArrayList((Collection)annotationsPerEntity.get(entity));
            ArrayList keyElements = new ArrayList(((Map)keyValues.get(0)).keySet());
            keyElements.forEach(keyElement -> selectables.add(CQL.get((String)keyElement)));
            Object entityName = context.getEvent().startsWith("DRAFT_") ? entity.getQualifiedName() + "_drafts" : entity.getQualifiedName();
            Select query = Select.from((String)entityName).columns(selectables).where((CqnPredicate)CQL.in(keyElements, (Collection)keyValues));
            Result readonlyResult = this.db.run((CqnSelect)query, new Object[0]);
            readonlyResult.forEach(row -> {
                HashMap keys = new HashMap(keyElements.size());
                ArrayList dynamicReadonly = new ArrayList(selectables.size() - keyElements.size());
                row.forEach((k, v) -> {
                    if (k.startsWith(READONLY_PREFIX) && Boolean.TRUE.equals(v)) {
                        dynamicReadonly.add(k.substring(READONLY_PREFIX.length()));
                    } else if (keyElements.contains(k)) {
                        keys.put(k, v);
                    }
                });
                if (!dynamicReadonly.isEmpty()) {
                    dynamicReadonlyPerEntity.computeIfAbsent(entity, e -> new HashMap(keyValues.size())).put(keys, dynamicReadonly);
                }
            });
        });
        if (dynamicReadonlyPerEntity.isEmpty()) {
            return;
        }
        DataProcessor.create().bulkAction((type, entries) -> {
            Map dynamicReadonly = (Map)dynamicReadonlyPerEntity.get(type);
            if (dynamicReadonly == null) {
                return;
            }
            Set keyNames = CdsModelUtils.concreteKeyNames((CdsStructuredType)type);
            entries.forEach(entry -> {
                Map<String, Object> keyValues = keyNames.stream().collect(Collectors.toMap(keyName -> keyName, entry::get));
                List readonlyElements = (List)dynamicReadonly.get(keyValues);
                if (readonlyElements != null) {
                    readonlyElements.forEach(entry::remove);
                }
            });
        }).process(dataList, (CdsStructuredType)context.getTarget());
    }

    private List<CqnSelectListValue> collectReadonlyExpressions(CdsStructuredType type) {
        ArrayList<CqnSelectListValue> readonlyExpressions = new ArrayList<CqnSelectListValue>();
        type.elements().forEach(e -> {
            if (CdsAnnotations.READONLY.isExpression((CdsAnnotatable)e)) {
                readonlyExpressions.add(SelectListValueBuilder.select((CqnValue)CdsAnnotations.READONLY.asPredicate((CdsAnnotatable)e)).as(READONLY_PREFIX + e.getName()).build());
            }
        });
        return readonlyExpressions;
    }

    public boolean isStaticallyReadOnly(CdsElement element, String event, boolean skipReadonly, Map<String, Object> map) {
        Map commonFieldControl;
        Object object;
        if (CdsAnnotations.ON_UPDATE.getOrDefault((CdsAnnotatable)element) != null || CdsAnnotations.ON_INSERT.getOrDefault((CdsAnnotatable)element) != null) {
            return true;
        }
        if (CdsAnnotations.READONLY.isExpression((CdsAnnotatable)element)) {
            return false;
        }
        if (!skipReadonly && (this.isElementAnnotatedWithStaticReadonly(element) || CdsAnnotations.FIELD_CONTROL_READONLY.isTrue((CdsAnnotatable)element) || (object = CdsAnnotations.COMMON_FIELDCONTROL.getOrDefault((CdsAnnotatable)element)) instanceof Map && "ReadOnly".equals((commonFieldControl = (Map)object).get("#")))) {
            return true;
        }
        if (!element.isKey()) {
            if (!skipReadonly && CdsAnnotations.CORE_COMPUTED.isTrue((CdsAnnotatable)element)) {
                return true;
            }
            boolean coreImmutable = CdsAnnotations.CORE_IMMUTABLE.isTrue((CdsAnnotatable)element);
            return coreImmutable && "UPDATE".equals(event) && !Boolean.FALSE.equals(map.get("HasActiveEntity"));
        }
        return false;
    }

    private boolean isElementAnnotatedWithStaticReadonly(CdsElement element) {
        if (CdsAnnotations.READONLY.isTrue((CdsAnnotatable)element)) {
            return true;
        }
        if (element.getType().isAssociation() && this.cdsProperties.getQuery().getDeepEntityReadonly().isEnabled().booleanValue()) {
            CdsEntity targetType = ((CdsAssociationType)element.getType().as(CdsAssociationType.class)).getTarget();
            return CdsAnnotations.READONLY.isTrue((CdsAnnotatable)targetType);
        }
        return false;
    }
}

