/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.draft;

import com.google.common.annotations.VisibleForTesting;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.cqn.AnalysisResult;
import com.sap.cds.ql.cqn.CqnAnalyzer;
import com.sap.cds.ql.cqn.CqnFilterableStatement;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.ql.cqn.ResolvedSegment;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.impl.draft.DraftModifier;
import com.sap.cds.services.impl.utils.CdsModelUtils;
import com.sap.cds.services.utils.DraftUtils;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

public class CqnAdapter {
    private final EventContext context;
    private final CqnAnalyzer analyzer;

    private CqnAdapter(EventContext context) {
        this.context = context;
        this.analyzer = CqnAnalyzer.create((CdsModel)context.getModel());
    }

    public static CqnAdapter create(EventContext context) {
        return new CqnAdapter(context);
    }

    public <T extends CqnStatement> T adaptForActiveExecution(T stmt) {
        CqnSelect s;
        if (stmt instanceof CqnSelect && !(s = (CqnSelect)stmt).from().isRef()) {
            return stmt;
        }
        if (this.isValidForActiveExecution(stmt)) {
            return this.adapt(stmt, true);
        }
        return null;
    }

    public <T extends CqnStatement> T adaptForInactiveExecution(T stmt) {
        if (this.isValidForInactiveExecution(stmt)) {
            return this.adapt(stmt, false);
        }
        return null;
    }

    @VisibleForTesting
    boolean isValidForActiveExecution(CqnStatement statement) {
        AnalysisResult analysisResult = this.analyze(statement);
        Iterator iterator = analysisResult.iterator();
        while (iterator.hasNext()) {
            Boolean isActiveEntity;
            ResolvedSegment segment = (ResolvedSegment)iterator.next();
            if (!DraftUtils.isDraftEnabled((CdsAnnotatable)segment.type()) || !Boolean.FALSE.equals(isActiveEntity = this.determineIsActiveEntity(segment, !iterator.hasNext() ? analysisResult.targetKeyValues() : Collections.emptyMap()))) continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    boolean isValidForInactiveExecution(CqnStatement statement) {
        AnalysisResult analysisResult = this.analyze(statement);
        Iterator iterator = analysisResult.iterator();
        CdsEntity previous = null;
        while (iterator.hasNext()) {
            ResolvedSegment segment = (ResolvedSegment)iterator.next();
            boolean isDraftEnabled = DraftUtils.isDraftEnabled((CdsAnnotatable)segment.type());
            Boolean isActiveEntity = this.determineIsActiveEntity(segment, !iterator.hasNext() ? analysisResult.targetKeyValues() : Collections.emptyMap());
            if (previous == null) {
                if (!isDraftEnabled || Boolean.TRUE.equals(isActiveEntity)) {
                    return false;
                }
            } else if (isDraftEnabled) {
                CdsEntity draftEntity = DraftModifier.getDraftsEntity(previous, this.context.getModel());
                boolean isSameDraftDocument = draftEntity.getTargetOf(segment.segment().id()).getName().endsWith("_drafts");
                if (Boolean.TRUE.equals(isActiveEntity) && isSameDraftDocument) {
                    return false;
                }
                if (Boolean.FALSE.equals(isActiveEntity) && !isSameDraftDocument) {
                    return false;
                }
            }
            previous = segment.entity();
        }
        return true;
    }

    private <T extends CqnStatement> T adapt(T stmt, boolean isActiveExecution) {
        CdsEntity rootEntity = CdsModelUtils.getEntityPath(stmt, this.context.getModel()).rootEntity();
        boolean addSecurityConstraints = stmt.isSelect();
        boolean stripIsActiveEntity = !stmt.isInsert() && !stmt.isSelect();
        return (T)CQL.copy(stmt, (Modifier)new DraftModifier(rootEntity, isActiveExecution, addSecurityConstraints, stripIsActiveEntity, this.context));
    }

    private AnalysisResult analyze(CqnStatement statement) {
        if (statement.isSelect()) {
            return this.analyzer.analyze((CqnFilterableStatement)statement.asSelect());
        }
        if (statement.isUpdate()) {
            return this.analyzer.analyze((CqnFilterableStatement)statement.asUpdate());
        }
        if (statement.isInsert()) {
            return this.analyzer.analyze(statement.asInsert().ref());
        }
        return this.analyzer.analyze((CqnFilterableStatement)statement.asDelete());
    }

    private Boolean determineIsActiveEntity(ResolvedSegment segment, Map<String, Object> targetKeys) {
        Boolean result = (Boolean)segment.keyValues().get("IsActiveEntity");
        if (result == null && targetKeys.get("IsActiveEntity") instanceof Boolean) {
            result = (Boolean)targetKeys.get("IsActiveEntity");
        }
        return result;
    }
}

