/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.draft;

import com.sap.cds.CdsDataProcessor;
import com.sap.cds.Result;
import com.sap.cds.ResultBuilder;
import com.sap.cds.Row;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Delete;
import com.sap.cds.ql.Insert;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.RefBuilder;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.Selectable;
import com.sap.cds.ql.Update;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnComparisonPredicate;
import com.sap.cds.ql.cqn.CqnDelete;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnInsert;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.ql.impl.DeleteBuilder;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.Service;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.cds.CdsReadEventContext;
import com.sap.cds.services.draft.DraftEditEventContext;
import com.sap.cds.services.draft.DraftNewEventContext;
import com.sap.cds.services.draft.DraftPrepareEventContext;
import com.sap.cds.services.draft.DraftSaveEventContext;
import com.sap.cds.services.draft.DraftService;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.cds.CapabilitiesHandler;
import com.sap.cds.services.impl.draft.CqnAdapter;
import com.sap.cds.services.impl.draft.DraftActivesReader;
import com.sap.cds.services.impl.draft.DraftHandlerUtils;
import com.sap.cds.services.impl.draft.DraftInactivesReader;
import com.sap.cds.services.impl.draft.DraftMergedReader;
import com.sap.cds.services.impl.draft.DraftModifier;
import com.sap.cds.services.impl.draft.DraftScenarioAnalyzer;
import com.sap.cds.services.impl.draft.DraftServiceImpl;
import com.sap.cds.services.impl.utils.CdsModelUtils;
import com.sap.cds.services.impl.utils.CdsServiceUtils;
import com.sap.cds.services.messages.Message;
import com.sap.cds.services.messages.MessageTarget;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.DraftUtils;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.model.CdsAnnotations;
import com.sap.cds.services.utils.model.CqnUtils;
import com.sap.cds.util.OccUtils;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@ServiceName(value={"*"}, type={DraftService.class})
public class DraftActionsHandler
implements EventHandler {
    @Before
    @HandlerOrder(value=-10500)
    protected void checkCapabilityNewDraft(DraftNewEventContext context) {
        if (!CapabilitiesHandler.getCapabilities((EventContext)context).isInsertable()) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ENTITY_NOT_INSERTABLE, new Object[]{context.getTarget().getQualifiedName()});
        }
    }

    @Before
    @HandlerOrder(value=-10500)
    protected void checkCapabilityEditDraft(DraftEditEventContext context) {
        if (!CapabilitiesHandler.getCapabilities((EventContext)context).isUpdatable()) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ENTITY_NOT_UPDATABLE, new Object[]{context.getTarget().getQualifiedName()});
        }
    }

    @Before(event={"draftActivate", "draftEdit", "draftPrepare"})
    @HandlerOrder(value=-10500)
    protected void checkRootDraft(EventContext context) {
        if (!DraftUtils.isDraftEnabled((CdsAnnotatable)context.getTarget())) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ENTITY_NOT_DRAFT_ENABLED, new Object[]{context.getTarget().getQualifiedName()});
        }
        if (!DraftUtils.isDraftRoot((CdsAnnotatable)context.getTarget())) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ENTITY_NOT_ROOT, new Object[]{context.getTarget().getQualifiedName()});
        }
    }

    @On
    @HandlerOrder(value=10900)
    protected Result defaultRead(CdsReadEventContext context) {
        return this.readInternal(context.getCqn(), context.getCqnNamedValues(), (EventContext)context);
    }

    private Result readInternal(CqnSelect select, Map<String, Object> cqnNamedValues, EventContext context) {
        String persistence = DraftHandlerUtils.getDraftPersistenceMode(context);
        DraftScenarioAnalyzer.AnalysisResult analysisResult = this.avoidScenarioAnalysis(select, persistence) ? new DraftScenarioAnalyzer.AnalysisResult(DraftScenarioAnalyzer.Scenario.NOT_OPTIMIZABLE, null, null) : DraftScenarioAnalyzer.analyze(select, context.getTarget(), context.getModel());
        switch (analysisResult.scenario()) {
            case ALL: {
                return DraftMergedReader.create(context).allScenario(select, cqnNamedValues, analysisResult.predicate(), analysisResult.ref());
            }
            case OWN_DRAFT: {
                return DraftInactivesReader.create(context).allInactives(select, cqnNamedValues, analysisResult.predicate(), analysisResult.ref(), false);
            }
            case DRAFT_ADMINISTRATIVE_DATA_VIA_ACTIVE: {
                return DraftInactivesReader.create(context).allInactives(select, cqnNamedValues, analysisResult.predicate(), analysisResult.ref(), true);
            }
            case ALL_HIDING_DRAFTS: {
                return DraftActivesReader.create(context).allActives(select, cqnNamedValues, analysisResult.predicate(), analysisResult.ref());
            }
            case LOCKED_BY_ANOTHER_USER: {
                return DraftActivesReader.create(context).withDraftsFromOtherUsers(select, cqnNamedValues, analysisResult.predicate(), analysisResult.ref(), true);
            }
            case UNSAVED_CHANGES_BY_ANOTHER_USER: {
                return DraftActivesReader.create(context).withDraftsFromOtherUsers(select, cqnNamedValues, analysisResult.predicate(), analysisResult.ref(), false);
            }
            case OTHER: {
                return DraftMergedReader.create(context).mergedSanitized(select, cqnNamedValues);
            }
            case UNCHANGED: {
                if (!"split".equals(persistence)) break;
                return DraftActivesReader.create(context).withoutDrafts(select, cqnNamedValues, analysisResult.predicate(), analysisResult.ref());
            }
        }
        return DraftMergedReader.create(context).merged(select, cqnNamedValues);
    }

    private boolean avoidScenarioAnalysis(CqnSelect select, String persistence) {
        if ("joint-strict".equals(persistence)) {
            return true;
        }
        if ("joint".equals(persistence) && select.from().isRef()) {
            return select.ref().rootSegment().filter().isPresent();
        }
        return false;
    }

    @On
    @HandlerOrder(value=11000)
    protected Result defaultPrepare(DraftPrepareEventContext context) {
        Result result = context.getService().run(context.getCqn(), new Object[0]);
        if (result.rowCount() == 0L) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ENTITY_INSTANCE_NOT_FOUND, new Object[]{context.getTarget().getQualifiedName(), com.sap.cds.services.utils.model.CdsModelUtils.getTargetKeysAsString((CdsModel)context.getModel(), (CqnStatement)context.getCqn())});
        }
        result.forEach(r -> {
            if (!Boolean.FALSE.equals(r.get((Object)"IsActiveEntity"))) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ENTITY_NOT_INACTIVE, new Object[0]);
            }
        });
        return result;
    }

    @On
    @HandlerOrder(value=11000)
    protected Result defaultSave(DraftSaveEventContext context) {
        Result deleteResult;
        Select select = Select.copy((CqnSelect)context.getCqn()).columns(DraftActionsHandler.expandCompositions(context.getTarget()));
        Result entriesToSave = this.readInternal((CqnSelect)select, context.getCqnNamedValues(), (EventContext)context);
        CdsDataProcessor.create().addGenerator((p, e, t) -> t.isSimple(), (p, e, n) -> null).process((Iterable)entriesToSave, (CdsStructuredType)context.getTarget());
        if (entriesToSave.rowCount() == 0L) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ENTITY_INSTANCE_NOT_FOUND, new Object[]{context.getTarget().getQualifiedName(), com.sap.cds.services.utils.model.CdsModelUtils.getTargetKeysAsString((CdsModel)context.getModel(), (CqnStatement)select)});
        }
        ArrayList newEntities = new ArrayList();
        ArrayList existingEntities = new ArrayList();
        entriesToSave.forEach(r -> {
            if (!Boolean.FALSE.equals(r.get((Object)"IsActiveEntity"))) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ENTITY_NOT_INACTIVE, new Object[0]);
            }
            if (((Boolean)r.get((Object)"HasActiveEntity")).booleanValue()) {
                existingEntities.add(r);
            } else {
                newEntities.add(r);
            }
        });
        CqnDelete delete = (CqnDelete)CqnAdapter.create((EventContext)context).adaptForInactiveExecution(CqnUtils.toDelete((CqnSelect)select));
        if (delete == null) {
            deleteResult = DraftHandlerUtils.buildNoOpResult((EventContext)context);
        } else {
            delete = (CqnDelete)CqnUtils.addWhere((CqnStatement)delete, (CqnPredicate)DraftModifier.getSecurityConstraints((EventContext)context));
            List cqnValueSets = context.getCqnNamedValues() != null ? Arrays.asList(context.getCqnNamedValues()) : Collections.emptyList();
            deleteResult = CdsServiceUtils.getDefaultPersistenceService((EventContext)context).run(delete, cqnValueSets);
        }
        if (deleteResult.rowCount() != entriesToSave.rowCount()) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ENTITY_NOT_INACTIVE, new Object[0]);
        }
        try {
            CdsProperties properties = context.getCdsRuntime().getEnvironment().getCdsProperties();
            HashMap<String, Boolean> hints = new HashMap<String, Boolean>();
            hints.put("draftActivate", true);
            if (properties.getDrafts().isEnforceReadonly()) {
                hints.put("@readonly", false);
            }
            ArrayList rows = new ArrayList();
            if (!newEntities.isEmpty()) {
                CqnInsert insert = (CqnInsert)Insert.into((CdsEntity)context.getTarget()).entries(newEntities).hints(hints);
                context.getService().run(insert).stream().forEach(rows::add);
            }
            if (!existingEntities.isEmpty()) {
                CqnUpdate update = (CqnUpdate)Update.entity((CdsEntity)context.getTarget()).entries(existingEntities).where((CqnPredicate)DraftActionsHandler.etagStar(context.getTarget())).hints(hints);
                context.getService().run(update, new Object[0]).stream().forEach(rows::add);
            }
            rows.forEach(row -> DraftActionsHandler.removeCompositionsAndAssociations(row, context.getTarget()));
            Result result = ResultBuilder.insertedRows(rows).result();
            return result;
        }
        catch (ServiceException e2) {
            DraftActionsHandler.rewriteMessageTarget(e2);
            throw e2;
        }
        finally {
            context.getMessages().stream().forEach(DraftActionsHandler::rewriteMessageTarget);
        }
    }

    private static void rewriteMessageTarget(ServiceException e) {
        e.messageTarget(DraftActionsHandler.rewriteMessageTarget(e.getMessageTarget()));
        e.additionalTargets(e.getAdditionalTargets().stream().map(DraftActionsHandler::rewriteMessageTarget).toList());
    }

    private static void rewriteMessageTarget(Message message) {
        message.target(DraftActionsHandler.rewriteMessageTarget(message.getTarget()));
        message.additionalTargets(message.getAdditionalTargets().stream().map(DraftActionsHandler::rewriteMessageTarget).toList());
    }

    private static MessageTarget rewriteMessageTarget(MessageTarget target) {
        if (target == null || target.getRef() == null || !"cqn".equals(target.getParameter())) {
            return target;
        }
        RefBuilder ref = CQL.copy((CqnElementRef)CQL.get((List)target.getRef().segments()));
        ref.stream().forEach(DraftActionsHandler::rewriteTargets);
        return MessageTarget.create((String)target.getParameter(), (CqnReference)ref.build());
    }

    private static void rewriteTargets(RefBuilder.RefSegment segment) {
        segment.filter().map(f -> CQL.copy((CqnPredicate)f, (Modifier)new TargetsToInactive())).ifPresent(arg_0 -> ((RefBuilder.RefSegment)segment).filter(arg_0));
    }

    private static Predicate etagStar(CdsEntity target) {
        return OccUtils.getVersionElement((CdsStructuredType)target).isPresent() ? CQL.eTag((Object)"*") : CQL.TRUE;
    }

    @On
    @HandlerOrder(value=11000)
    protected Result defaultEdit(DraftEditEventContext context) {
        Select select = Select.copy((CqnSelect)context.getCqn()).columns(DraftActionsHandler.expandCompositions(context.getTarget()));
        Result entriesToEdit = (Result)context.getCdsRuntime().requestContext().modifyParameters(param -> param.setLocale(null)).run(arg_0 -> this.lambda$defaultEdit$7((CqnSelect)select, context, arg_0));
        if (entriesToEdit.rowCount() == 0L) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ENTITY_INSTANCE_NOT_FOUND, new Object[]{context.getTarget().getQualifiedName(), com.sap.cds.services.utils.model.CdsModelUtils.getTargetKeysAsString((CdsModel)context.getModel(), (CqnStatement)select)});
        }
        entriesToEdit.forEach(r -> {
            if (!Boolean.TRUE.equals(r.get((Object)"IsActiveEntity"))) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ENTITY_NOT_ACTIVE, new Object[0]);
            }
            DraftActionsHandler.clearOnUpdateFields((Map<String, Object>)r, context.getTarget());
        });
        if (context.getPreserveChanges() != null && !context.getPreserveChanges().booleanValue()) {
            Delete delete = CqnUtils.toDelete((CqnSelect)context.getCqn());
            Instant timeoutThreshold = DraftModifier.getCancellationThreshold((EventContext)context);
            Predicate timeoutCondition = CQL.to((String)"DraftAdministrativeData").anyMatch(d -> d.get("LastChangeDateTime").le((Object)timeoutThreshold));
            ((DeleteBuilder)delete).filter((CqnPredicate)timeoutCondition);
            CqnDelete deleteStatement = (CqnDelete)CqnAdapter.create((EventContext)context).adaptForActiveExecution(delete);
            context.getCdsRuntime().requestContext().privilegedUser().run(requestContext -> context.getService().cancelDraft(deleteStatement, new Object[0]));
        }
        Insert insert = Insert.into((String)context.getTarget().getQualifiedName()).entries((Iterable)entriesToEdit);
        Result result = DraftServiceImpl.downcast((Service)context.getService()).createDraft((CqnInsert)insert, true);
        return result;
    }

    private static void clearOnUpdateFields(Map<String, Object> m, CdsEntity entity) {
        CdsModelUtils.visitDeep(entity, m, (cdsEntity, data, parent, parentData) -> cdsEntity.elements().filter(e -> CdsAnnotations.ON_UPDATE.getOrDefault((CdsAnnotatable)e) != null).map(e -> e.getName()).forEach(e -> data.remove(e)));
    }

    private static List<Selectable> expandCompositions(CdsEntity entity) {
        ArrayList<Selectable> columns = new ArrayList<Selectable>();
        columns.add((Selectable)CQL.star());
        entity.compositions().forEach(co -> {
            CdsEntity target = (CdsEntity)entity.getTargetOf(co.getName());
            if (DraftUtils.isDraftEnabled((CdsAnnotatable)target)) {
                columns.add((Selectable)CQL.to((String)co.getName()).expand(DraftActionsHandler.expandCompositions(target)));
            }
        });
        return columns;
    }

    private static void removeCompositionsAndAssociations(Row r, CdsEntity entity) {
        Iterator iter = r.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            if (!(entry.getValue() instanceof List) && !(entry.getValue() instanceof Map) || !entity.findAssociation((String)entry.getKey()).isPresent()) continue;
            iter.remove();
        }
    }

    private /* synthetic */ Result lambda$defaultEdit$7(CqnSelect select, DraftEditEventContext context, RequestContext reqContext) {
        return this.readInternal(select, context.getCqnNamedValues(), (EventContext)context);
    }

    private static class TargetsToInactive
    implements Modifier {
        private TargetsToInactive() {
        }

        public CqnPredicate comparison(Value<?> lhs, CqnComparisonPredicate.Operator op, Value<?> rhs) {
            if (lhs.isRef() && lhs.asRef().path().equals("IsActiveEntity") && op == CqnComparisonPredicate.Operator.EQ && rhs == CQL.TRUE) {
                return CQL.comparison(lhs, (CqnComparisonPredicate.Operator)op, (CqnValue)CQL.FALSE);
            }
            return CQL.comparison(lhs, (CqnComparisonPredicate.Operator)op, rhs);
        }
    }
}

