/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.draft.messages;

import com.sap.cds.CdsData;
import com.sap.cds.Struct;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.draft.DraftReadEventContext;
import com.sap.cds.services.draft.DraftService;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.After;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.draft.messages.DraftMessage;
import com.sap.cds.services.impl.draft.messages.DraftMessageUtils;
import com.sap.cds.services.messages.MessageLookup;
import com.sap.cds.services.messages.MessageTarget;
import com.sap.cds.services.utils.DraftUtils;
import com.sap.cds.services.utils.ODataUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@ServiceName(value={"*"}, type={DraftService.class})
class DraftMessagesReadHandler
implements EventHandler {
    DraftMessagesReadHandler() {
    }

    @Before
    @HandlerOrder(value=11300)
    void selectMessages(DraftReadEventContext context) {
        if (!DraftUtils.isDraftEnabled((CdsAnnotatable)context.getTarget())) {
            return;
        }
        context.setCqn((CqnSelect)CQL.copy((CqnStatement)context.getCqn(), (Modifier)new Modifier(){

            public CqnValue ref(CqnElementRef ref) {
                if (ref.path().equals("DraftMessages")) {
                    return CQL.get((String)"DraftAdministrativeData.DraftMessages");
                }
                return ref;
            }
        }));
    }

    @After
    @HandlerOrder(value=-11000)
    void postProcessMessages(DraftReadEventContext context, List<CdsData> dataList) {
        if (!DraftUtils.isDraftEnabled((CdsAnnotatable)context.getTarget())) {
            return;
        }
        CqnStructuredTypeRef refForTarget = DraftMessageUtils.forTarget(context.getCqn().ref());
        String requestTarget = refForTarget != null ? ODataUtils.toODataTarget(null, null, (CqnReference)refForTarget, (boolean)false, (boolean)false) : null;
        for (CdsData data : dataList) {
            Collection draftMessages = (Collection)data.get((Object)"DraftMessages");
            if (draftMessages == null) continue;
            Iterator iterator = draftMessages.iterator();
            while (iterator.hasNext()) {
                DraftMessage draftMessage = (DraftMessage)Struct.access((Map)((Map)iterator.next())).as(DraftMessage.class);
                Targets targets = this.relevantTargets(requestTarget, draftMessage, (EventContext)context);
                if (requestTarget == null || targets.target != null) {
                    MessageLookup lookup = DraftMessageUtils.parseMessageLookup(draftMessage.getMessage());
                    String localized = context.getCdsRuntime().getLocalizedMessage(lookup.getMessageOrKey(), lookup.getArgs(), context.getParameterInfo().getLocale());
                    draftMessage.setMessage(localized);
                    if (targets.target != null) {
                        draftMessage.setTarget(targets.target);
                    }
                    if (targets.additionalTargets.isEmpty()) continue;
                    draftMessage.setAdditionalTargets(targets.additionalTargets);
                    continue;
                }
                iterator.remove();
            }
        }
    }

    private Targets relevantTargets(String requestTarget, DraftMessage draftMessage, EventContext context) {
        String target = this.getEffectiveTarget(requestTarget, draftMessage.getTarget());
        List<String> additionalTargets = List.of();
        if (draftMessage.getAdditionalTargets() != null) {
            additionalTargets = new ArrayList(draftMessage.getAdditionalTargets().size());
            for (String additionalTarget : draftMessage.getAdditionalTargets()) {
                String effectiveAdditionalTarget = this.getEffectiveTarget(requestTarget, additionalTarget);
                if (effectiveAdditionalTarget == null) continue;
                additionalTargets.add(effectiveAdditionalTarget);
            }
        }
        if (target != null) {
            return new Targets(target, additionalTargets);
        }
        return new Targets(!additionalTargets.isEmpty() ? additionalTargets.remove(0) : null, additionalTargets);
    }

    private String getEffectiveTarget(String requestTarget, String rawTarget) {
        MessageTarget target = DraftMessageUtils.parseMessageTarget(rawTarget);
        if (target != null) {
            String odataTarget = ODataUtils.toODataTarget(null, (String)target.getParameter(), (CqnReference)target.getRef(), (boolean)false, (boolean)false);
            if (requestTarget == null || odataTarget != null && (odataTarget.equals(requestTarget) || odataTarget.startsWith(requestTarget + "/"))) {
                if (requestTarget != null) {
                    odataTarget = odataTarget.substring(requestTarget.length() + (odataTarget.equals(requestTarget) ? 0 : 1));
                }
                return odataTarget;
            }
        }
        return null;
    }

    private record Targets(String target, List<String> additionalTargets) {
    }
}

