/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.handlerregistry.resolver;

import com.sap.cds.impl.builder.model.StructuredTypeImpl;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.CdsName;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.impl.handlerregistry.HandlerDescriptor;
import com.sap.cds.services.impl.handlerregistry.resolver.ArgumentResolver;

public class CqnReferenceArgumentResolver
implements ArgumentResolver {
    private final Class<? extends StructuredType> structuredTypeClass;

    public static CqnReferenceArgumentResolver createIfApplicable(Class<?> type) {
        if (CqnStructuredTypeRef.class.equals(type)) {
            return new CqnReferenceArgumentResolver(null);
        }
        if (StructuredType.class.isAssignableFrom(type)) {
            return new CqnReferenceArgumentResolver(type);
        }
        return null;
    }

    private CqnReferenceArgumentResolver(Class<?> type) {
        this.structuredTypeClass = type;
    }

    @Override
    public Object resolve(EventContext context) {
        CqnStatement cqn = (CqnStatement)context.get("cqn");
        if (cqn != null && (!cqn.isSelect() || cqn.asSelect().from().isRef())) {
            CqnStructuredTypeRef ref = cqn.ref();
            if (this.structuredTypeClass != null) {
                if (StructuredType.class.equals(this.structuredTypeClass)) {
                    return StructuredTypeImpl.structuredType((CqnStructuredTypeRef)ref);
                }
                return CQL.entity(this.structuredTypeClass, (CqnStructuredTypeRef)ref);
            }
            return ref;
        }
        return null;
    }

    @Override
    public String[] indicateEntities() {
        CdsName entityName;
        if (this.structuredTypeClass != null && (entityName = this.structuredTypeClass.getAnnotation(CdsName.class)) != null) {
            return new String[]{entityName.value()};
        }
        return new String[0];
    }

    @Override
    public void verifyOrThrow(HandlerDescriptor descriptor) {
    }
}

