/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.messaging.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.sap.cds.impl.parser.JsonParser;
import com.sap.cds.impl.parser.token.Jsonizer;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.messaging.CloudEventMessageEventContext;
import com.sap.cds.services.messaging.TopicMessageEventContext;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.StringUtils;
import java.lang.management.ManagementFactory;
import java.time.Instant;
import java.util.Map;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CloudEventUtils {
    public static String toCloudEvent(String message, String defaultType, String namespace) {
        Map<String, Object> messageMap = CloudEventUtils.toMap(message);
        if (messageMap == null) {
            return message;
        }
        return CloudEventUtils.toJson(CloudEventUtils.toCloudEvent(messageMap, defaultType, namespace));
    }

    public static Map<String, Object> toCloudEvent(Map<String, Object> headers, String defaultType, String namespace) {
        headers.computeIfAbsent("id", k -> UUID.randomUUID().toString());
        headers.putIfAbsent("specversion", "1.0");
        headers.putIfAbsent("datacontenttype", "application/json");
        headers.computeIfAbsent("time", k -> Instant.now().toString());
        headers.putIfAbsent("type", defaultType);
        headers.computeIfAbsent("source", k -> CloudEventUtils.getDefaultSource(namespace));
        return headers;
    }

    private static String getDefaultSource(String namespace) {
        String source = null;
        if (namespace != null) {
            long slashCount;
            String normalizedNamespace = StringUtils.trim((String)namespace.trim(), (char)'/');
            if (normalizedNamespace.endsWith("/ce")) {
                normalizedNamespace = normalizedNamespace.substring(0, normalizedNamespace.length() - 3);
            }
            if (normalizedNamespace.endsWith("/-")) {
                normalizedNamespace = normalizedNamespace.substring(0, normalizedNamespace.length() - 2);
            }
            if ((slashCount = normalizedNamespace.chars().filter(ch -> ch == 47).count()) == 2L || slashCount == 1L) {
                source = "/" + normalizedNamespace;
            }
        }
        if (source == null) {
            source = "/default/sap.cap/" + CloudEventUtils.getPID();
        }
        return source;
    }

    public static CloudEventMessageEventContext toCloudEventMessageContext(TopicMessageEventContext context, String eventName) {
        CloudEventMessageEventContext ctx = CloudEventMessageEventContext.create((String)eventName);
        if (context.getData() == null) {
            CloudEventUtils.copyEntries(ctx, context.getHeadersMap());
            ctx.put("data", (Object)context.getDataMap());
        } else {
            Map<String, Object> data = CloudEventUtils.toMap(context.getData());
            if (data == null) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_CLOUDEVENTS_MESSAGE, new Object[0]);
            }
            CloudEventUtils.copyEntries(ctx, data);
        }
        return ctx;
    }

    private static void copyEntries(CloudEventMessageEventContext ctx, Map<String, Object> map) {
        map.forEach((key, value) -> {
            if (key.equals("time")) {
                ctx.setTime(Instant.parse((String)value));
            } else {
                ctx.put(key, value);
            }
        });
    }

    public static String toJson(Map<String, Object> map) {
        return Jsonizer.json(map);
    }

    public static Map<String, Object> toMap(String jsonString) {
        try {
            return JsonParser.map((JsonNode)JsonParser.parseJson((String)jsonString));
        }
        catch (Exception e) {
            return null;
        }
    }

    private static long getPID() {
        String processName = ManagementFactory.getRuntimeMXBean().getName();
        if (!StringUtils.isEmpty((String)processName)) {
            try {
                return Long.parseLong(processName.split("@")[0]);
            }
            catch (Exception e) {
                return 0L;
            }
        }
        return 0L;
    }
}

