/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.messaging.utils;

import com.sap.cds.impl.util.Pair;
import com.sap.cds.services.environment.ApplicationInfo;
import com.sap.cds.services.messaging.TopicMessageEventContext;
import com.sap.cds.services.messaging.utils.CloudEventUtils;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagingUtils {
    private static final Logger logger = LoggerFactory.getLogger(MessagingUtils.class);

    public static String getQueueName(String service, ApplicationInfo config) {
        String qualifier;
        String name;
        StringBuilder queue = new StringBuilder(MessagingUtils.normalizeName(config.getName()));
        int lastIdx = service.lastIndexOf(46);
        if (lastIdx > 0) {
            name = service.substring(lastIdx + 1);
            qualifier = service.substring(0, lastIdx);
        } else {
            name = service;
            qualifier = "";
        }
        queue.append('/');
        queue.append(MessagingUtils.getShortHash(config.getId()));
        queue.append('/');
        queue.append(MessagingUtils.normalizeName(name));
        queue.append('/');
        queue.append(MessagingUtils.getShortHash(qualifier));
        return queue.toString();
    }

    public static String toStringMessage(TopicMessageEventContext context) {
        HashMap<String, Object> messageMap = new HashMap<String, Object>(context.getHeadersMap());
        messageMap.put("data", context.getDataMap());
        return CloudEventUtils.toJson(messageMap);
    }

    public static Pair<Map<String, Object>, Map<String, Object>> toStructuredMessage(String message) {
        Map<Object, Object> headersMap;
        Map<Object, Object> dataMap;
        if (message == null) {
            dataMap = new HashMap();
            headersMap = new HashMap();
        } else {
            Map<String, Object> map = CloudEventUtils.toMap(message);
            if (map != null) {
                Object data = map.get("data");
                if (data instanceof Map) {
                    dataMap = (Map)map.remove("data");
                    headersMap = map;
                } else if (data == null && map.containsKey("data")) {
                    dataMap = new HashMap();
                    headersMap = map;
                    headersMap.remove("data");
                } else {
                    dataMap = map;
                    headersMap = new HashMap();
                }
            } else {
                dataMap = new HashMap<String, String>(Map.of("message", message));
                headersMap = new HashMap();
            }
        }
        return Pair.of(dataMap, headersMap);
    }

    private static String normalizeName(String name) {
        return name.replaceAll("[^a-zA-Z0-9\\*\\.]", "").replace('.', '/');
    }

    private static String getShortHash(String text) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(text.getBytes(StandardCharsets.UTF_8));
            byte[] digest = md.digest();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < digest.length && i < 2; ++i) {
                sb.append("%02x".formatted(digest[i] & 0xFF));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("Could not get MD5 algorithm", (Throwable)e);
            return text;
        }
    }
}

