/*
 * © 2020-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.messaging.jms;

import jakarta.jms.Message;

@FunctionalInterface
public interface TopicAccessor {

  /**
   * Retrieves the topic from a JMS message
   *
   * @param message the JMS message
   * @return the topic
   */
  public String getFromTopic(Message message);
}
