/*
 * © 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.messaging.utils;

import com.sap.cds.services.environment.CdsProperties.Messaging.MessagingServiceConfig;
import com.sap.cds.services.messaging.MessagingService;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.outbox.OutboxUtils;

public class MessagingOutboxUtils {

  private MessagingOutboxUtils() {
    // hidden
  }

  public static <S extends MessagingService> S outboxed(
      S service, MessagingServiceConfig config, CdsRuntime runtime) {
    if (config.getOutbox().isEnabled()) {
      return OutboxUtils.outboxed(service, config.getOutbox().getName(), runtime);
    }
    return service;
  }
}
