/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.messaging.jms;

import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.messaging.TopicMessageEventContext;
import com.sap.cds.services.messaging.utils.MessagingUtils;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import java.nio.charset.StandardCharsets;

class MessageEmitter {
    private final Session session;
    private final MessageProducer producer;

    MessageEmitter(Connection connection) throws JMSException {
        this.session = connection.createSession();
        this.producer = this.session.createProducer(null);
    }

    public void emitTopicMessage(String topic, TopicMessageEventContext messageEventContext) {
        try {
            Topic jmsTopic = this.session.createTopic(topic);
            this.producer.send((Destination)jmsTopic, (Message)this.createByteMessage(MessagingUtils.toStringMessage(messageEventContext)));
        }
        catch (JMSException e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.EVENT_EMITTING_FAILED, new Object[]{topic, e});
        }
    }

    private BytesMessage createByteMessage(String content) throws JMSException {
        BytesMessage msg = this.session.createBytesMessage();
        msg.clearBody();
        msg.writeBytes(content.getBytes(StandardCharsets.UTF_8));
        return msg;
    }
}

