/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.utils;

import com.sap.cds.services.handler.annotations.HandlerOrder;

/**
 * This interface is NOT part of the public API.
 * The constants in this interface are intended for internal usage in cds-services.
 * No guarantees are provided that the exact values of these constants remain stable.
 *
 * If its required to order your own custom handlers in your application,
 * refer to {@link HandlerOrder} and the respective constants defined there.
 */
public interface OrderConstants {

	static interface On {

		// priority of built-in default ON handlers provided by the framework
		int DEFAULT_ON = 10 * HandlerOrder.AFTER + HandlerOrder.LATE;
		// makes sure reject handler is last
		int REJECT = Integer.MAX_VALUE;
		int AUTO_COMPLETE = REJECT - 1;

		// before default ON handlers
		int FEATURE = 1 * HandlerOrder.BEFORE + DEFAULT_ON;

		// before usual custom ON handlers
		int MESSAGING = HandlerOrder.AFTER + HandlerOrder.EARLY;

	}

	static interface Before {

		// only used for persistence (not directly exposed as external API)
		int TRANSACTION_BEGIN = 20 * HandlerOrder.BEFORE + HandlerOrder.EARLY;

		// before usual custom handlers
		int CHECK_ENTITY_FITS = 10 * HandlerOrder.BEFORE + HandlerOrder.EARLY;
		int CHECK_AUTHORIZATION = HandlerOrder.AFTER + CHECK_ENTITY_FITS;
		int CHECK_CAPABILITIES = HandlerOrder.AFTER + CHECK_AUTHORIZATION;
		int FILTER_FIELDS = HandlerOrder.AFTER + CHECK_CAPABILITIES;

		// after usual custom handlers
		int CALCULATE_FIELDS = 10 * HandlerOrder.AFTER + HandlerOrder.LATE;
		int VALIDATE_FIELDS = HandlerOrder.AFTER + CALCULATE_FIELDS;
		int THROW_IF_ERROR = HandlerOrder.AFTER + VALIDATE_FIELDS;

	}

	static interface After {

		// before usual custom handlers
		int ADD_FIELDS = 10 * HandlerOrder.BEFORE + HandlerOrder.EARLY;

	}

}
