/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.utils.index;

import java.util.ArrayList;
import java.util.Iterator;

import javax.servlet.Servlet;

import com.sap.cds.adapter.IndexContentProvider;
import com.sap.cds.adapter.IndexContentProviderFactory;
import com.sap.cds.adapter.ServletAdapterFactory;
import com.sap.cds.adapter.UrlResourcePath;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.CdsRuntimeAware;
import com.sap.cds.services.runtime.ExtendedServiceLoader;
import com.sap.cds.services.utils.path.UrlPathUtil;
import com.sap.cds.services.utils.path.UrlResourcePathBuilder;

public class IndexPageServletFactory implements ServletAdapterFactory, CdsRuntimeAware {

	private CdsRuntime runtime;

	@Override
	public void setCdsRuntime(CdsRuntime runtime) {
		this.runtime = runtime;
	}

	@Override
	public Servlet create() {
		// load all index content providers
		ArrayList<IndexContentProvider> contentProviders = new ArrayList<>();
		Iterator<IndexContentProviderFactory> factoryIterator = ExtendedServiceLoader.loadAll(IndexContentProviderFactory.class, runtime);
		factoryIterator.forEachRemaining(factory -> {
			if (factory.isEnabled()) {
				IndexContentProvider provider = factory.create();
				contentProviders.add(provider);
			}
		});
		return new IndexPageServlet(contentProviders);
	}

	@SuppressWarnings("deprecation")
	@Override
	public boolean isEnabled() {
		return runtime.getEnvironment().getCdsProperties().getIndexPage().isEnabled()
				// evaluate the old property for the OData V4 index page as well, for backwards-compatibility reasons
				&& runtime.getEnvironment().getCdsProperties().getOdataV4().getIndexPage().isEnabled();
	}

	@SuppressWarnings("deprecation")
	@Override
	public String getBasePath() {
		String path = runtime.getEnvironment().getCdsProperties().getIndexPage().getPath();
		// if this is the default path setting, also check the old property for the OData V4 index page
		// for backwards-compatibility reasons
		if ("/".equals(path)) {
			path = runtime.getEnvironment().getCdsProperties().getOdataV4().getIndexPage().getPath();
		}
		return UrlPathUtil.normalizeBasePath(path);
	}

	@Override
	public String[] getMappings() {
		return new String[] { UrlResourcePathBuilder.path(getBasePath()).build().getPath() };
	}

	@Override
	public UrlResourcePath getServletPath() {
		return UrlResourcePathBuilder.path(getBasePath()).isPublic(true).build();
	}

}
