/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.utils.info;

import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.CdsRuntimeAware;

/**
 * A {@link CdsInfo} describes a part of the CDS runtime stack.
 * Implementing classes can get access to the {@link CdsRuntime} by implementing {@link CdsRuntimeAware}.
 */
public interface CdsInfo {

	/**
	 * @return	The name of the info section
	 */
	String name();

	/**
	 * Controls level of detail of the content presented
	 */
	enum Details {
		LOW,
		MEDIUM,
		HIGH;
	}

	/**
	 * Provides the information in a specific flavor.
	 *
	 * @param details	Specifies the detail level of the information
	 * @return	The information, potentially in a recursive structure
	 */
	Object info(Details details);

}
