/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.utils.messaging.service;

import java.util.Objects;

public class MessageTopic {

	private final String eventName; // the topic name used in handlers
	private final String brokerName; // the topic name used in brokers

	public MessageTopic(String name) {
		this.eventName = name;
		this.brokerName = name;
	}

	public MessageTopic(String eventName, String brokerName) {
		this.eventName = eventName;
		this.brokerName = brokerName;
	}

	public String getEventName() {
		return eventName;
	}

	public String getBrokerName() {
		return brokerName;
	}

	@Override
	public boolean equals(Object obj) {
		if(obj != null && obj.getClass() == this.getClass()) {
			return Objects.equals(brokerName, ((MessageTopic) obj).brokerName);
		}
		return false;
	}

	@Override
	public int hashCode() {
		return Objects.hashCode(brokerName);
	}

}
