/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.utils.messaging.service;

import com.sap.cds.services.Service;
import com.sap.cds.services.messaging.TopicMessageEventContext;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;

/**
 * This class provides the implementation of a message listener which is responsible for
 * passing the received message to the service layer in order to invoke the appropriate custom
 * handler
 */
public class MessagingBrokerQueueListener {

	private final Service service;
	private final String queueName;
	private final MessageQueue queue;

	public MessagingBrokerQueueListener(Service service, String queueName, MessageQueue queue) {
		this.service = service;
		this.queueName = queueName;
		this.queue = queue;
	}

	public String getQueueName() {
		return queueName;
	}

	public void receivedMessage(String message, String brokerTopicName, String messageId) {
		String eventTopicName = queue.findTopic(brokerTopicName).getEventName();
		try {
			TopicMessageEventContext context = getContext(message, eventTopicName, messageId);
			service.emit(context);
		} catch (Exception e) { // NOSONAR
			throw new ErrorStatusException(CdsErrorStatuses.EVENT_PROCESSING_FAILED, eventTopicName, service.getName(), queueName, e);
		}
	}

	private TopicMessageEventContext getContext(String message, String eventTopicName, String messageId) {
		TopicMessageEventContext context = TopicMessageEventContext.create(eventTopicName);
		context.setData(message);
		context.setMessageId(messageId);
		context.setIsInbound(true);
		return context;
	}
}
