/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.utils.rest.client;

/**
 * Provides the authentication configuration for the REST client.
 *
 */
public interface JsonRestClientConfiguration {

	/**
	 * Configuration name.
	 *
	 * @return name
	 */
	public String getName();

	/**
	 * REST-API endpoint URL.
	 *
	 * @return REST-API URL
	 */
	public String getApiUrl();

	/**
	 * Authentication endpoint URL.
	 *
	 * @return authorization endpoint URL
	 */
	public String getTokenEndpoint();

	/**
	 * Authentication grant type.
	 *
	 * @return grant type
	 */
	public String getGrantType();

	/**
	 * Authentication client
	 *
	 * @return client
	 */
	public String getClientId();

	/**
	 * Authentication secret
	 *
	 * @return secret
	 */
	public String getClientSecret();
}
