/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils;

import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ErrorStatuses;

public enum CdsErrorStatuses implements ErrorStatus
{
    INVALID_CQN(400001, "Invalid CQN: {}", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    INVALID_DATE_VALUE(400002, "Provided value in query parameter '{}' is not a valid date value (expected ISO 8601 date time format)", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    ENTITY_NOT_DRAFT_ENABLED(400003, "Entity '{}' is not draft enabled", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    ENTITY_NOT_ROOT(400004, "Entity '{}' is not the root entity of the draft-enabled composition tree", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    ENTITY_NOT_ACTIVE(400005, "Only active draft-enabled entities (IsActiveEntity = true) are allowed", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    ENTITY_NOT_INACTIVE(400006, "Only inactive draft-enabled entities (IsActiveEntity = false) are allowed", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    INVALID_URI_RESOURCE(400007, "URI resource is invalid", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    INVALID_PAYLOAD(400008, "Could not deserialize request payload: {}", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    INVALID_EXPAND_STAR(400009, "Expand '*' can't be combined with further expands", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    INVALID_SUBSTRING(400010, "Invalid number of parameters for filter function 'substring'", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    MISSING_CONTENT_TYPE(400011, "'Content-Type' request header required", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    VALUE_OUT_OF_RANGE(400012, "Value of element '{}' is out of range (minimum value '{}' and maximum value '{}')", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    DRAFT_DEEP_UPDATE(400013, "Deep updates are not allowed when patching an inactive draft-enabled entity (IsActiveEntity = false)", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    TENANT_NOT_KNOWN(400014, "Tenant '{}' not known", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    INVALID_ENUM(400015, "Provided enum value of element '{}' is not in the list of allowed enum values '{}'", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    INVALID_SORT_ELEMENT(400016, "Could not sort by element '{}' of entity '{}'", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    INVALID_PARAMETERIZED_VIEW(400017, "You need to use the 'Set' navigation property when accessing a parameterized view", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    INVALID_STRING_VALUE(400018, "Provided value of element '{}' does not match the expected pattern", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    EXCEEDED_FIELD_LENGTH(400019, "Provided value of element '{}' exceeds maximum length of {}", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    NO_CUSTOM_AGGREGATE_DEFINED(400020, "No custom aggregate is defined for element '{}'", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    MISSING_ISACTIVEENTITY_KEY(400021, "The IsActiveEntity key is missing for path segments prior to an association to a draft enabled entity", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    UNKONWN_AGGREGATION_METHOD(400022, "The aggregate method '{}' is unknown", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    TENANT_CONTEXT_MISSING(401001, "Ensure authenticated user context is provided and contains tenant information", (ErrorStatus)ErrorStatuses.UNAUTHORIZED),
    TOKEN_PARSING_FAILED(401002, "Failed to parse JWT token", (ErrorStatus)ErrorStatuses.UNAUTHORIZED),
    EVENT_FORBIDDEN(403001, "Not authorized to send event '{}' to '{}'", (ErrorStatus)ErrorStatuses.FORBIDDEN),
    SERVICE_NOT_FOUND(404001, "Service '{}' not found", (ErrorStatus)ErrorStatuses.NOT_FOUND),
    ENTITY_NOT_FOUND(404002, "Entity '{}' not found", (ErrorStatus)ErrorStatuses.NOT_FOUND),
    ACTION_NOT_FOUND(404003, "Action '{}' not found", (ErrorStatus)ErrorStatuses.NOT_FOUND),
    FUNCTION_NOT_FOUND(404004, "Function '{}' not found", (ErrorStatus)ErrorStatuses.NOT_FOUND),
    ASSOCIATION_NOT_FOUND(404005, "Association '{}' in entity '{}' not found", (ErrorStatus)ErrorStatuses.NOT_FOUND),
    ELEMENT_NOT_FOUND(404006, "Element '{}' of entity '{}' not found", (ErrorStatus)ErrorStatuses.NOT_FOUND),
    TENANT_NOT_FOUND(404007, "Tenant '{}' not found", (ErrorStatus)ErrorStatuses.NOT_FOUND),
    JOB_NOT_FOUND(404008, "Asynchronous schema deployment job '{}' not found", (ErrorStatus)ErrorStatuses.NOT_FOUND),
    ENTITY_INSTANCE_NOT_FOUND(404009, "Entity '{}' with key(s) '{}' not found", (ErrorStatus)ErrorStatuses.NOT_FOUND),
    FUNCTION_RETURN_VALUE_NOT_FOUND(404010, "Function '{}' should return a single value, but no return value found", (ErrorStatus)ErrorStatuses.NOT_FOUND),
    ENTITY_NOT_READABLE(405001, "Entity '{}' is not readable", (ErrorStatus)ErrorStatuses.METHOD_NOT_ALLOWED),
    ENTITY_NOT_INSERTABLE(405002, "Entity '{}' is not insertable", (ErrorStatus)ErrorStatuses.METHOD_NOT_ALLOWED),
    ENTITY_NOT_UPDATABLE(405003, "Entity '{}' is not updatable", (ErrorStatus)ErrorStatuses.METHOD_NOT_ALLOWED),
    ENTITY_NOT_DELETABLE(405004, "Entity '{}' is not deletable", (ErrorStatus)ErrorStatuses.METHOD_NOT_ALLOWED),
    VALUE_ACCESS_NOT_ALLOWED(406001, "Not allowed to access $value of stream element '{}'", (ErrorStatus)ErrorStatuses.NOT_ACCEPTABLE),
    CONSTRAINT_VIOLATED(409001, "Conflict: {}", (ErrorStatus)ErrorStatuses.CONFLICT),
    PARENT_NOT_EXISTING(409002, "Couldn't find parent entity for entity '{}'", (ErrorStatus)ErrorStatuses.CONFLICT),
    VALUE_REQUIRED(409003, "Value of element '{}' in entity '{}' is required", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    MULTIPLE_PARENTS(409004, "Found {} parent entities for entity '{}', but only a single one is allowed", (ErrorStatus)ErrorStatuses.CONFLICT),
    MULTIPLE_SINGLETON_ENTRIES(409005, "Only a single entry is allowed, when upserting an existing singleton", (ErrorStatus)ErrorStatuses.CONFLICT),
    UNIQUE_CONSTRAINT_VIOLATED(409006, "Unique constraint violated when inserting or updating entity '{}'", (ErrorStatus)ErrorStatuses.CONFLICT),
    LOCK_TIMEOUT(409007, "Timeout while waiting for lock on entity '{}'", (ErrorStatus)ErrorStatuses.CONFLICT),
    ETAG_FAILED(412001, "ETag condition not met", (ErrorStatus)ErrorStatuses.PRECONDITION_FAILED),
    MISDIRECTED_ENTITY(421001, "Service '{}' does not contain entity '{}' and CQN statement can't be projected onto the service", (ErrorStatus)ErrorStatuses.MISDIRECTED_REQUEST),
    ETAG_REQUIRED(428001, "'If-Match' or 'If-None-Match' request header with etag condition required", (ErrorStatus)ErrorStatuses.PRECONDITION_REQUIRED),
    ETAG_VALUE_INVALID(428002, "Invalid ETag: Value could not be converted to '{}'", (ErrorStatus)ErrorStatuses.PRECONDITION_REQUIRED),
    NO_ON_HANDLER(50001001, "No ON handler completed the processing", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    HANDLER_FAILED(50001002, "Could not create handler instance of type '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    HANDLER_NOT_ACCESSIBLE(50001003, "Can't access method handle for '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    HANDLER_SERVICE_REQUIRED(50001004, "Failed to register handler method '{}': No service name specified.", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    HANDLER_EVENT_REQUIRED(50001005, "Failed to register handler method '{}': No event definition in annotations or arguments.", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    EVENT_CONTEXT_EVENT_MISMATCH(50001006, "EventContext '{}' is bound to event '{}' and does not match event '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    EVENT_CONTEXT_MISSING_ANNOTATION(50001007, "EventContext '{}' is missing required @EventName annotation", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    EVENT_CONTEXT_ARGUMENT_MISSING_ANNOTATION(50001008, "Method '{}' has parameter of EventContext type '{}' which misses required @EventName annotation", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    EVENT_CONTEXT_ARGUMENT_MULTIPLE_EVENTS(50001009, "Method '{}' has parameter of EventContext type '{}' but is registered for multiple events", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    EVENT_CONTEXT_ARGUMENT_MISMATCH(50001010, "Method '{}' has parameter of EventContext type '{}' which does not exactly fit registered event '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    EVENT_CONTEXT_ARGUMENT_DUPLICATES(50001011, "Method '{}' declares multiple EventContext arguments, but only a maximum of one is supported", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    POJO_ARGUMENT_MISMATCH(50001012, "Event '{}' not supported, when requiring argument '{}' in method '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    POJO_ARGUMENT_DUPLICATES(50001013, "Method '{}' declares multiple entity-based arguments, but only a maximum of one is supported", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    RETURN_TYPE_MISMATCH(50001014, "Event '{}' not supported, when returning '{}' in method '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    RESOLVING_PARAMETER_TYPE_FAILED(50001015, "Can't resolve parameter type '{}' of method '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    RESOLVING_RETURN_TYPE_FAILED(50001016, "Can't resolve return type '{}' of method '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    INVALID_TYPE(50001017, "'{}' is not a parameterized type", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    UNEXPECTED_EVENT(50002001, "Unexpected event '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    UNKNOWN_EVENT_PHASE(50002002, "Unknown event phase '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    EVENT_NAME_REQUIRED(50002003, "Event name must not be null or empty", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    SERVICE_NAME_REQUIRED(50002004, "Service name must not be null or empty", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    DUPLICATE_SERVICE(50002005, "Can't register service with duplicate service name '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    CHANGESET_CANCELATION_FAILED(50003001, "Unexpected exception during cancelation of member '{}' in ChangeSet '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    CHANGESET_COMPLETION_FAILED(50003002, "Unexpected exception during completion of member '{}' in ChangeSet '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    MULTIPLE_CHANGE_SET_MEMBERS(50003003, "A member is already registered on ChangeSet '{}': Only a single member is supported", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    PLAIN_REQUEST_CONTEXT_NESTING(50003004, "Can't nest PlainRequestContextHolder", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    TRANSACTION_TENANT_MISMATCH(50003005, "Database transaction was started for tenant '{}', but now found active tenant '{}': Create dedicated ChangeSet Contexts for each tenant", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    TEMPORARY_REQUEST_CONTEXT_MESSAGES(50003006, "A messages object cannot be retrieved from a temporary RequestContext", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    INVALID_WHERE_CONDITION(50004001, "Invalid where condition '{}' for entity '{}', event '{}' and user '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    INVALID_CSV_FILE(50004002, "Failed to read CSV file from path '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    NO_PARENT_ENTITY(50004003, "Failed to find parent entity of '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    NO_KEYS_IN_RESULT(50004004, "Failed to determine keys of entity '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    INVALID_ANNOTATION(50004005, "Invalid annotation '{}' for element '{}' in entity '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    INVALID_CSN(50004006, "Failed to load CDS model from CSN file at resource path '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    INCONSISTENT_WHERE_CONDITION(50004007, "No CXN expression found for where condition '{}' used for instance-based authorization of entity '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    INVALID_BATCH_UPDATE(50004008, "Invalid batched update: Parameter value list size {} does not match batch size {}", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    NO_SERVICE_BINDING(50005001, "No service binding with tag '{}' found", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    MULTIPLE_SERVICE_BINDING(50005002, "Multiple service bindings with tag '{}' found: Only a single one is allowed", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    NO_DATA_SOURCE_PROVIDER(50005003, "Could not build SQL DataSource from service binding '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    JDBC_CONNECTION_FAILED(50005004, "Can't obtain JDBC SQL connection", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    INVALID_SERVICE_NAME(50005005, "Could not find service binding with name '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    SUBSCRIBER_FAILED(50006001, "Could not initialize multitenant subscription client", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    INSTANCE_MANAGER_CLIENT_FAILED(50006002, "Could not create Instance Manager or Service Manager client from service binding '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    SUBSCRIPTION_FAILED(50006003, "Failed to process subscription of tenant '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    UNSUBSCRIPTION_FAILED(50006004, "Failed to cancel subscription of tenant '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    DEPLOYMENT_FAILED(50006005, "Failed to deploy schema for tenant(s) '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    JOB_STATUS_UPDATE_FAILED(50006006, "Failed to update status for asynchronous schema deployment job '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    SUBSCRIBE_CALLBACK_FAILED(50006007, "Failed to call SaaS Provisioning service after subscribe request of tenant '{}' finished", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    UNSUBSCRIBE_CALLBACK_FAILED(50006008, "Failed to call SaaS Provisioning service after unsubscribe request of tenant '{}' finished", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    COMBINE_DATASOURCE_POOLS_FAILED(50006009, "Database IDs need to be configured to enable data source setting: 'combinePools'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    TENANT_READ_FAILED(50006010, "Failed to read tenant ids", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    EDMX_READ_FAILED(50006011, "Failed to read EDMX for service '{}' from MTX sidecar", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    MT_LIB_SETUP_FAILED(50006012, "Could not setup multi tenancy library: '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    NO_UNIQUE_DATASOURCE_SERVICE(50006013, "Failed to determine a unique service binding to configure the primary datasource. Please specify cds.dataSource.binding", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    INVALID_CDS_MESSAGE(50007002, "Failed to parse message as CDS message", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    INVALID_S4_MESSAGE(50007003, "Failed to parse message as S/4 HANA message", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    INVALID_MESSAGE_TIMESTAMP(50007005, "Could not parse timestamp of message", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    INVALID_BROKER_CONFIGURATION(50007006, "Invalid messaging broker configuration for service '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    EVENT_PROCESSING_FAILED(50007009, "Failed to process event '{}' on service '{}' received on queue '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    EVENT_EMITTING_FAILED(50007011, "Failed to send message to topic '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    NO_WEBHOOK_URL(50007012, "Failed to determine application URL for webhook registration", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    NO_TENANT_INFO(50007013, "Required tenant information is missing in the request context", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    UNKNOWN_TENANT(50007014, "Could not determine subdomain for tenant '{}'", (ErrorStatus)ErrorStatuses.NOT_FOUND),
    TENANT_ADMIN_FORBIDDEN(50007015, "Not authorized for enterprise-messaging tenant management", (ErrorStatus)ErrorStatuses.FORBIDDEN),
    UPDATE_TENANT_IS_RUNNING(50007016, "The tenant update is currently running", (ErrorStatus)ErrorStatuses.CONFLICT),
    TENANT_SYNC_SUBSCRIBE_FORBIDDEN(50007017, "Only asynchronous SaaS subscription is supported when using enterprise-messaging with multitenancy", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    INVALID_METADATA(50008001, "File '{}' is not a valid V4 metadata file", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    RESPONSE_SERIALIZATION_FAILED(50008002, "Failed to serialize response payload", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    DESERIALIZER_FAILED(50008003, "Failed to create deserializer", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    SERIALIZER_FAILED(50008004, "Failed to create serializer", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    UNEXPECTED_URI_RESOURCE(50008005, "Unexpected URI resource type '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    UNEXPECTED_EDM_TYPE(50008006, "Unexpected EDM type '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    ORDERBY_PARSING_FAILED(50008007, "Failed to transform $orderby to CQN", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    FILTER_PARSING_FAILED(50008008, "Failed to transform $filter to CQN", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    SELECT_PARSING_FAILED(50008009, "Failed to transform $select to CQN", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    MISSING_VALUE_FOR_COUNT(50008010, "The query result misses a value for $count", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    VALUE_PARSING_FAILED(50008011, "Failed to transform expression to CQN value", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    INVALID_METADATA_MTX(50008012, "MTX sidecar did not respond with a valid V4 metadata file for service '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    SEARCH_PARSING_FAILED(50009001, "Failed to transform custom 'search' option to CQN", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    INVALID_METADATA_V2(50009002, "File '{}' is not a valid V2 metadata file", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    RESOLVING_FUNCTION_IMPORT_ANNOTATION_FAILED(50009003, "Failed to resolve annotations for function import '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    MISSING_EDM_PROPERTY(50009004, "Failed to get EDM property '{}' from EDM entity/type '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    INVALID_METADATA_V2_MTX(50009005, "MTX sidecar did not respond with a valid V2 metadata file for service '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    INVALID_CSV_FILE_ENTITYNOTFOUND(50010001, "Can't find an entity '{}' matching CSV file '{}'.", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    INVALID_CSV_FILE_NOHEADER(50010002, "CSV file '{}' has no header line", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    INVALID_CSV_FILE_INVALIDHEADER(50010003, "CSV file '{}' has header line with delimiters ';' and ','", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    INVALID_CSV_FILE_UNKNOWNCOLUMN(50010004, "CSV file '{}' has column '{}' which does not exist on entity '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    INVALID_CSV_FILE_TYPEMISMATCH(50010005, "Value '{}' does not match type '{}' of column '{}' in CSV file '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    CONFIGURER_COMPLETED(50011001, "The CDS runtime configurer is already completed: Changes to the underlying CDS runtime are no longer allowed", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    INVALID_CONFIGURATION_PHASE(50011002, "An operation of phase '{}' is not allowed anymore, as the CDS runtime configurer is already in phase '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    REMOTE_ODATA_PATH_EXPR(50012001, "Could not transform CQN to OData request: Accessing elements through path expressions is not supported by the OData protocol", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    REMOTE_ODATA_REF_TYPE(50012003, "Could not transform CQN to OData request: Failed to determine the type of the reference '{}' in entity '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    REMOTE_ODATA_TYPE_CONV(50012004, "Could not convert object '{}' of type '{}' to CDS base type '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    REMOTE_ODATA_ERROR_RESPONSE(50012005, "The remote OData service responded with status code '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    REMOTE_ODATA_FUNCTION(50012006, "Could not transform CQN to OData request: The function '{}' is not supported", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    REMOTE_ODATA_NUM_ARGS(50012007, "Could not transform CQN to OData request: Wrong number of arguments was provided for function '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    REMOTE_ODATA_OPERATOR(50012008, "Could not transform CQN to OData request: The operator '{}' is used incorrectly", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    REMOTE_ODATA_FUNCTION_VERSION(50012009, "Could not transform CQN to OData request: The function '{}' is not supported for OData version '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    REMOTE_ODATA_V2_LAMBDA(50012010, "Could not transform CQN to OData request: Lambda operators are not supported in OData V2", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    REMOTE_ODATA_JSON_SERIALIZATION(50012011, "Could not serialize entry to OData compatible JSON", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    REMOTE_ODATA_ONLY_COLLECTION(50012012, "Could not transform CQN to OData request: POST requests are only supported on collections", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    REMOTE_ODATA_ONLY_ENTITY(50012013, "Could not transform CQN to OData request: PATCH/DELETE requests are only supported on single entities", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    REMOTE_ODATA_INCOMPLETE_KEY(50012014, "Could not transform CQN to OData request: Could not retrieve values for all keys of entity '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    REMOTE_ODATA_INVALID_LAMBDA_ALL(50012015, "Could not transform CQN to OData request: Lambda 'all' statements without argument are not supported", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    REMOTE_ODATA_MISSING_STATEMENT(50012016, "Could not transform CQN to OData request: CQN Select Statement defining the target of the operation is missing", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    REMOTE_ODATA_EMPTY_SELECTION(50012017, "Could not transform CQN to OData request: Empty select list. All elements have been excluded.", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    NO_SERVICE_IN_CATALOG(50013001, "Could not find destination service with name '{}', configured for composite service '{}', in the service catalog", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    NO_DESTINATION_SERVICE(50013002, "No destination service defined for the event '{}' in the composite service configuration '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    INVALID_SECRETS_PATH(50014001, "Secrets path '{}' of service binding '{}' is not a directory", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    INVALID_PROPERTY_FILE(50014002, "Could not read property file '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    APP_PROPERTIES_UNSUPPORTED(50014003, "Kubernetes does not provide an application name or ID", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    MULTIPLE_APPLICATION_URLS(50015001, "Cannot determine the application url because multiple URIs are provided by VCAP_APPLICATION", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    AUDITLOG_SERVICE_NOT_AVAILABLE(50016001, "Auditlog service is not reachable", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    AUDITLOG_SERVICE_INVALID_MESSAGE(50016002, "Invalid auditlog message", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    AUDITLOG_SERVICE_INVALID_CONFIG(50016003, "Auditlog service configuration is invalid, parameter '{}' is missing", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    AUDITLOG_SERVICE_NO_USER(50016004, "User information is missing, can't log audit message", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    AUDITLOG_SERVICE_INVALID_PLAN(50016005, "Auditlog service plan '{}' not supported", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    UNSUPPORTED_ACTION_FUNCTION_RETURN_TYPE(501001, "Action or function return values of type '{}' are not yet supported", (ErrorStatus)ErrorStatuses.NOT_IMPLEMENTED),
    UNSUPPORTED_METHOD(501002, "Method '{}' is not yet supported", (ErrorStatus)ErrorStatuses.NOT_IMPLEMENTED),
    UNSUPPORTED_OPERATOR(501003, "Operator '{}' is not yet supported", (ErrorStatus)ErrorStatuses.NOT_IMPLEMENTED),
    UNSUPPORTED_EXPAND_ALL_IN_DRAFT(501004, "Expanding all fields on a draft enabled entity is not yet supported", (ErrorStatus)ErrorStatuses.NOT_IMPLEMENTED),
    UNSUPPORTED_PATH_IN_DRAFT(501005, "Expanding or inlining a draft enabled entity via a path is not supported", (ErrorStatus)ErrorStatuses.NOT_IMPLEMENTED),
    UNSUPPORTED_APPLY_OPTION(501006, "Apply option '{}' is not yet supported", (ErrorStatus)ErrorStatuses.NOT_IMPLEMENTED),
    UNSUPPORTED_CONCAT_LAST(501007, "'concat' is currently only supported as the last transformation of $apply", (ErrorStatus)ErrorStatuses.NOT_IMPLEMENTED),
    UNSUPPORTED_CONCAT_SYSTEMQUERY(501008, "Transformation 'concat' with system query option {} is not supported", (ErrorStatus)ErrorStatuses.NOT_IMPLEMENTED);

    private final int code;
    private final String description;
    private final ErrorStatus httpError;

    private CdsErrorStatuses(int code, String description, ErrorStatus httpError) {
        this.code = code;
        this.description = description;
        this.httpError = httpError;
    }

    public int getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public int getHttpStatus() {
        return this.httpError.getHttpStatus();
    }

    public ErrorStatus getHttpError() {
        return this.httpError;
    }
}

