/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils;

import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.utils.StringUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocaleUtils {
    private static final Logger logger = LoggerFactory.getLogger(LocaleUtils.class);
    private static final String LOCALIZED_PREFIX = "localized";
    private static final String SAPTRC_ALIAS = "1Q";
    private static final Locale SAPTRC_LOCALE = Locale.forLanguageTag("en-US-x-saptrc");
    private static final Locale SAPTRC_BUNDLE = Locale.forLanguageTag("en-US-saptrc");
    private static final String SAPPSD_ALIAS = "2Q";
    private static final Locale SAPPSD_LOCALE = Locale.forLanguageTag("en-US-x-sappsd");
    private static final Locale SAPPSD_BUNDLE = Locale.forLanguageTag("en-US-sappsd");
    private static final String SAPRIGI_ALIAS = "3Q";
    private static final Locale SAPRIGI_LOCALE = Locale.forLanguageTag("en-US-x-saprigi");
    private static final Locale SAPRIGI_BUNDLE = Locale.forLanguageTag("en-US-saprigi");
    private final Set<Locale> localeIncludeList = new HashSet<Locale>();

    public LocaleUtils(CdsProperties properties) {
        this.calculateLocaleIncludeList(properties.getLocales().getNormalization());
    }

    void calculateLocaleIncludeList(CdsProperties.Locales.Normalization config) {
        this.localeIncludeList.clear();
        if (config.isDefaults()) {
            List<Locale> defaultIncludeList = Arrays.asList(Locale.forLanguageTag("zh-CN"), Locale.forLanguageTag("zh-HK"), Locale.forLanguageTag("zh-TW"), Locale.forLanguageTag("en-GB"), Locale.forLanguageTag("fr-CA"), Locale.forLanguageTag("pt-PT"), Locale.forLanguageTag("es-CO"), Locale.forLanguageTag("es-MX"), SAPTRC_LOCALE, SAPPSD_LOCALE, SAPRIGI_LOCALE);
            this.localeIncludeList.addAll(defaultIncludeList);
        }
        config.getIncludeList().stream().map(t -> Locale.forLanguageTag(t)).forEach(this.localeIncludeList::add);
    }

    public Locale getLocale(String sapLanguageQueryParam, String xSapLanguageHeader, String acceptLanguageHeader) {
        Locale locale = null;
        if (!StringUtils.isEmpty(sapLanguageQueryParam)) {
            locale = sapLanguageQueryParam.equals(SAPTRC_ALIAS) ? SAPTRC_LOCALE : (sapLanguageQueryParam.equals(SAPPSD_ALIAS) ? SAPPSD_LOCALE : (sapLanguageQueryParam.equals(SAPRIGI_ALIAS) ? SAPRIGI_LOCALE : Locale.forLanguageTag(sapLanguageQueryParam)));
        } else if (!StringUtils.isEmpty(xSapLanguageHeader)) {
            locale = Locale.forLanguageTag(xSapLanguageHeader);
        } else if (!StringUtils.isEmpty(acceptLanguageHeader)) {
            try {
                locale = Locale.LanguageRange.parse(acceptLanguageHeader).stream().map(range -> Locale.forLanguageTag(range.getRange())).findFirst().orElse(null);
            }
            catch (IllegalArgumentException e) {
                logger.debug("Omitting invalid accept header '{}': {} ", (Object)acceptLanguageHeader, (Object)e.getMessage());
            }
        }
        if (locale != null && !this.localeIncludeList.contains(locale)) {
            locale = new Locale(locale.getLanguage());
        }
        return locale;
    }

    public static String getLocalizedEntityName(String entity) {
        return "localized." + entity;
    }

    public static String getLocaleStringForQuery(Locale locale) {
        if (SAPTRC_LOCALE.equals(locale)) {
            return SAPTRC_ALIAS;
        }
        if (SAPPSD_LOCALE.equals(locale)) {
            return SAPPSD_ALIAS;
        }
        if (SAPRIGI_LOCALE.equals(locale)) {
            return SAPRIGI_ALIAS;
        }
        return locale.toLanguageTag();
    }

    public static Locale getLocaleForBundle(Locale locale) {
        if (SAPTRC_LOCALE.equals(locale)) {
            return SAPTRC_BUNDLE;
        }
        if (SAPPSD_LOCALE.equals(locale)) {
            return SAPPSD_BUNDLE;
        }
        if (SAPRIGI_LOCALE.equals(locale)) {
            return SAPRIGI_BUNDLE;
        }
        return locale;
    }
}

