/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils.datasource;

import com.sap.cds.services.datasource.DataSourceDescriptor;
import com.sap.cds.services.datasource.DataSourceDescriptorFactory;
import com.sap.cds.services.datasource.DataSourceFactory;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.ExtendedServiceLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.sql.DataSource;

public class DataSourceUtils {
    public static List<DataSourceDescriptor> getDataSourceDescriptors(CdsRuntime runtime) {
        ArrayList<DataSourceDescriptor> descriptors = new ArrayList<DataSourceDescriptor>();
        ExtendedServiceLoader.loadAll(DataSourceDescriptorFactory.class, (CdsRuntime)runtime).forEachRemaining(p -> descriptors.addAll(p.create()));
        return descriptors;
    }

    public static Map<String, DataSource> getDataSources(CdsRuntime runtime) {
        HashMap<String, DataSource> dataSources = new HashMap<String, DataSource>();
        ExtendedServiceLoader.loadAll(DataSourceFactory.class, (CdsRuntime)runtime).forEachRemaining(p -> dataSources.putAll(p.create()));
        return dataSources;
    }

    public static String getDataSourceSection(String name, PoolType poolType) {
        return String.format("cds.data-source.%s.%s", new Object[]{DataSourceUtils.toKebabCase(name), poolType});
    }

    private static String toKebabCase(String str) {
        return str.toLowerCase(Locale.US).replace("_", "-");
    }

    public static enum PoolType {
        HIKARI("hikari"),
        TOMCAT("tomcat"),
        DBCP2("dbcp2"),
        ATOMIKOS("atomikos");

        private final String poolType;

        private PoolType(String poolType) {
            this.poolType = poolType;
        }

        public String toString() {
            return this.poolType;
        }
    }
}

