/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils.messaging;

import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsService;
import com.sap.cds.services.environment.ApplicationInfo;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagingUtils {
    private static final Logger logger = LoggerFactory.getLogger(MessagingUtils.class);

    public static String getQueueName(String service, ApplicationInfo config) {
        String qualifier;
        String name;
        StringBuilder queue = new StringBuilder(MessagingUtils.normalizeName(config.getName()));
        int lastIdx = service.lastIndexOf(46);
        if (lastIdx > 0) {
            name = service.substring(lastIdx + 1);
            qualifier = service.substring(0, lastIdx);
        } else {
            name = service;
            qualifier = "";
        }
        queue.append('/');
        queue.append(MessagingUtils.getShortHash(config.getId()));
        queue.append('/');
        queue.append(MessagingUtils.normalizeName(name));
        queue.append('/');
        queue.append(MessagingUtils.getShortHash(qualifier));
        return queue.toString();
    }

    public static String getQueueName(CdsService service, ApplicationInfo config) {
        StringBuilder queue = new StringBuilder(MessagingUtils.normalizeName(config.getName()));
        queue.append('/');
        queue.append(MessagingUtils.getShortHash(config.getId()));
        queue.append('/');
        queue.append(MessagingUtils.normalizeName(service.getName()));
        queue.append('/');
        queue.append(MessagingUtils.getShortHash(service.getQualifier()));
        return queue.toString();
    }

    public static String getTopicPattern(CdsService service, CdsEntity entity, String event) {
        StringBuilder topic = new StringBuilder("CAP/");
        topic.append(MessagingUtils.normalizeName(service.getName()));
        topic.append('/');
        topic.append(MessagingUtils.getShortHash(service.getQualifier()));
        if (entity != null) {
            topic.append('/');
            topic.append(MessagingUtils.normalizeName(entity.getName()));
        }
        topic.append('/');
        topic.append(MessagingUtils.normalizeName(event));
        return topic.toString();
    }

    public static String getTopicPattern(String service, CdsEntity entity, String event) {
        return MessagingUtils.getTopicPattern(service, entity != null ? entity.getName() : null, event);
    }

    public static String getTopicPattern(String service, String entity, String event) {
        String qualifier;
        String name;
        StringBuilder topic = new StringBuilder("CAP/");
        int lastIdx = service.lastIndexOf(46);
        if (lastIdx >= 0) {
            name = service.substring(lastIdx + 1);
            qualifier = service.substring(0, lastIdx);
        } else {
            name = service;
            qualifier = "";
        }
        topic.append(MessagingUtils.normalizeName(name));
        topic.append('/');
        topic.append(MessagingUtils.getShortHash(qualifier));
        if (entity != null) {
            lastIdx = entity.lastIndexOf(46);
            if (lastIdx >= 0) {
                name = entity.substring(lastIdx + 1);
                qualifier = entity.substring(0, lastIdx);
                if (!qualifier.equals(service)) {
                    throw new ErrorStatusException(CdsErrorStatuses.MISDIRECTED_ENTITY, service, entity);
                }
                topic.append('/');
                topic.append(MessagingUtils.normalizeName(name));
            } else {
                topic.append('/');
                topic.append(MessagingUtils.normalizeName(entity));
            }
        }
        topic.append('/');
        topic.append(MessagingUtils.normalizeName(event));
        return topic.toString();
    }

    public static String normalizeName(String name) {
        return name.replaceAll("[^a-zA-Z0-9\\*\\.]", "").replace('.', '/');
    }

    private static String getShortHash(String text) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(text.getBytes(StandardCharsets.UTF_8));
            byte[] digest = md.digest();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < digest.length && i < 2; ++i) {
                sb.append(String.format("%02x", digest[i] & 0xFF));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("Could not get MD5 algorithm", (Throwable)e);
            return text;
        }
    }
}

