/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils.messaging.jms;

import com.sap.cds.services.utils.messaging.jms.MessageEmitter;
import com.sap.cds.services.utils.messaging.jms.MessageQueueReader;
import com.sap.cds.services.utils.messaging.jms.TopicAccessor;
import com.sap.cds.services.utils.messaging.service.MessagingBrokerQueueListener;
import java.io.IOException;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerConnection {
    private static final Logger logger = LoggerFactory.getLogger(BrokerConnection.class);
    private final String name;
    private final ConnectionFactory connectionFactory;
    private volatile Connection connection;
    private volatile MessageEmitter emitter;
    private volatile boolean isConnected;

    public BrokerConnection(String name, ConnectionFactory connectionFactory) {
        this.name = name;
        this.connectionFactory = connectionFactory;
    }

    public void connect() throws IOException {
        logger.debug("Opening the broker connection '{}'", (Object)this.name);
        if (!this.isConnected) {
            try {
                this.connection = this.connectionFactory.createConnection();
                this.connection.setExceptionListener(e -> {
                    logger.error("The broker connection '{}' is in trouble!", (Object)this.name, (Object)e);
                    this.isConnected = false;
                });
                this.emitter = new MessageEmitter(this.connection);
                this.connection.start();
                this.isConnected = true;
                logger.info("The messaging broker connection '{}' has been established.", (Object)this.name);
            }
            catch (JMSException e2) {
                throw new IOException("Broker connection lost", e2);
            }
        } else {
            logger.error("The broker connection '{}' is already connected!", (Object)this.name);
        }
    }

    public void close() throws JMSException {
        logger.debug("Closing the broker connection '{}'", (Object)this.name);
        this.connection.close();
        this.isConnected = false;
    }

    public void registerQueueListener(String queue, MessagingBrokerQueueListener listener, TopicAccessor topicAccessor, int maxFailedCount) throws IOException {
        try {
            logger.debug("Registering the queue listener on '{}'", (Object)queue);
            new MessageQueueReader(queue, listener, this.connection, topicAccessor, maxFailedCount).startListening();
        }
        catch (JMSException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public void emitTopicMessage(String topic, String message) {
        logger.debug("Emitting a message to the topic '{}'", (Object)topic);
        this.emitter.emitTopicMessage(topic, message);
    }

    public String getName() {
        return this.name;
    }

    public boolean isConnected() {
        return this.isConnected;
    }
}

