/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils.messaging.jms;

import com.sap.cds.services.utils.StringUtils;
import com.sap.cds.services.utils.messaging.jms.TopicAccessor;
import com.sap.cds.services.utils.messaging.service.MessagingBrokerQueueListener;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MessageQueueReader
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(MessageQueueReader.class);
    private TopicAccessor topicAccessor;
    private MessagingBrokerQueueListener listener;
    private String queueName;
    private Connection connection;
    private Session session;
    private Queue queue;
    private MessageConsumer consumer;
    private int maxFaildAttempts;
    private Map<String, Integer> failedCounter = new HashMap<String, Integer>();

    MessageQueueReader(String queueName, MessagingBrokerQueueListener listener, Connection connection, TopicAccessor topicAccessor, int maxFaildAttempts) throws JMSException {
        this.maxFaildAttempts = maxFaildAttempts;
        this.topicAccessor = topicAccessor;
        this.queueName = queueName;
        this.listener = listener;
        this.connection = connection;
        this.session = connection.createSession(false, 2);
        this.queue = this.session.createQueue(queueName);
        this.consumer = this.session.createConsumer((Destination)this.queue);
    }

    public void startListening() {
        new Thread((Runnable)this, this.queueName + " - Listener").start();
    }

    @Override
    public void run() {
        block5: while (true) {
            try {
                while (this.consumer != null) {
                    Message message = this.consumer.receive();
                    if (message == null) continue;
                    ReceivedMessage textMessage = null;
                    try {
                        textMessage = new ReceivedMessage(message, this.topicAccessor);
                        this.listener.receivedMessage(textMessage.getMessage(), textMessage.getTopic(), message.getJMSMessageID());
                        message.acknowledge();
                        continue block5;
                    }
                    catch (JMSException e) {
                        logger.warn("Failed to parse JMS message on queue '{}'", (Object)this.queueName, (Object)e);
                        this.checkUnhandledMessage(message);
                    }
                    catch (Throwable th) {
                        if (textMessage != null) {
                            logger.error("The received message of the queue '{}' and topic '{}' could not be handled!", new Object[]{this.queueName, !StringUtils.isEmpty(textMessage.getTopic()) ? textMessage.getTopic() : "???", th});
                        } else {
                            logger.error("The received message of the queue '{}' could not be handled!", (Object)this.queueName, (Object)th);
                        }
                        this.checkUnhandledMessage(message);
                    }
                }
                break;
            }
            catch (JMSException e) {
                logger.error("The queue reader '{}' was interrupted!", (Object)this.queueName, (Object)e);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkUnhandledMessage(Message message) throws JMSException {
        if (this.maxFaildAttempts > 0) {
            int failedAttempts;
            if (!this.failedCounter.containsKey(message.getJMSMessageID())) {
                this.failedCounter.put(message.getJMSMessageID(), 0);
            }
            if ((failedAttempts = this.failedCounter.get(message.getJMSMessageID()) + 1) >= this.maxFaildAttempts) {
                logger.debug("Auto-acknowledged message with ID '{}', as maximum failed attempts were reached", (Object)message.getJMSMessageID());
                message.acknowledge();
                this.failedCounter.remove(message.getJMSMessageID());
            } else {
                this.failedCounter.put(message.getJMSMessageID(), failedAttempts);
                try (Session prevSession = this.session;){
                    this.session = this.connection.createSession(false, 2);
                    this.queue = this.session.createQueue(this.queueName);
                    this.consumer = this.session.createConsumer((Destination)this.queue);
                }
            }
        }
    }

    private static class ReceivedMessage {
        private String message;
        private String topic;

        public ReceivedMessage(Message message, TopicAccessor topicAccessor) throws JMSException {
            if (message instanceof TextMessage) {
                TextMessage txtMsg = (TextMessage)message;
                this.message = txtMsg.getText();
                this.topic = topicAccessor.getFromTopic(message);
            } else if (message instanceof BytesMessage) {
                BytesMessage byteMsg = (BytesMessage)message;
                byte[] byteData = new byte[(int)byteMsg.getBodyLength()];
                byteMsg.readBytes(byteData);
                byteMsg.reset();
                this.message = new String(byteData, StandardCharsets.UTF_8);
                this.topic = topicAccessor.getFromTopic(message);
            } else {
                throw new JMSException("Unknown event message format: " + message.getClass().getName());
            }
        }

        public String getMessage() {
            return this.message;
        }

        public String getTopic() {
            return this.topic;
        }
    }
}

