/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils.messaging.service;

import com.sap.cds.services.environment.ApplicationInfo;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cds.services.utils.messaging.MessagingUtils;
import com.sap.cds.services.utils.messaging.service.MessageTopic;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class MessageQueue {
    private final String name;
    private final boolean fullyQualified;
    private final Map<String, String> properties;
    private final Set<MessageTopic> topics = new HashSet<MessageTopic>();

    static MessageQueue create(CdsProperties.Messaging.MessagingServiceConfig serviceConfig, ApplicationInfo applicationInfo) {
        MessageQueue queue;
        Map properties = serviceConfig.getQueue().getConfig();
        if (StringUtils.isEmpty(serviceConfig.getQueue().getName())) {
            String queueName = MessagingUtils.getQueueName(serviceConfig.getName(), applicationInfo);
            queue = new MessageQueue(queueName, false, properties);
        } else {
            String queueName = serviceConfig.getQueue().getName();
            queue = new MessageQueue(queueName, true, properties);
        }
        serviceConfig.getQueue().getSubscriptions().forEach(topic -> queue.addTopic(new MessageTopic((String)topic)));
        return queue;
    }

    private MessageQueue(String name, boolean fullyQualified, Map<String, String> properties) {
        this.name = name;
        this.fullyQualified = fullyQualified;
        this.properties = properties;
    }

    public String getName() {
        return this.name;
    }

    public boolean isFullyQualified() {
        return this.fullyQualified;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public List<MessageTopic> getTopics() {
        return this.topics.stream().collect(Collectors.toList());
    }

    public MessageTopic findTopic(String topic) {
        return this.topics.stream().filter(t -> Objects.equals(t.getBrokerName(), topic)).findFirst().orElse(new MessageTopic(topic));
    }

    public boolean hasEvent(String topic) {
        return this.topics.stream().filter(t -> Objects.equals(t.getEventName(), topic)).count() > 0L;
    }

    public void addTopic(MessageTopic topic) {
        this.topics.add(topic);
    }
}

