/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils.messaging.service;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.Service;
import com.sap.cds.services.messaging.TopicMessageEventContext;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.messaging.service.MessageQueue;

public class MessagingBrokerQueueListener {
    private final Service service;
    private final String queueName;
    private final MessageQueue queue;

    public MessagingBrokerQueueListener(Service service, String queueName, MessageQueue queue) {
        this.service = service;
        this.queueName = queueName;
        this.queue = queue;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void receivedMessage(String message, String brokerTopicName, String messageId) {
        String eventTopicName = this.queue.findTopic(brokerTopicName).getEventName();
        try {
            TopicMessageEventContext context = this.getContext(message, eventTopicName, messageId);
            this.service.emit((EventContext)context);
        }
        catch (Exception e) {
            throw new ErrorStatusException(CdsErrorStatuses.EVENT_PROCESSING_FAILED, eventTopicName, this.service.getName(), this.queueName, e);
        }
    }

    private TopicMessageEventContext getContext(String message, String eventTopicName, String messageId) {
        TopicMessageEventContext context = TopicMessageEventContext.create((String)eventTopicName);
        context.setData(message);
        context.setMessageId(messageId);
        context.setIsInbound(true);
        return context;
    }
}

