/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils.runtime;

import com.sap.cds.services.request.ParameterInfo;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.LocaleUtils;
import com.sap.cds.services.utils.TemporalRangeUtils;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;

public class HttpParameterInfo
implements ParameterInfo {
    private final HttpServletRequest httpRequest;
    private final LocaleUtils localeUtils;
    private Locale locale;
    private Instant validFrom;
    private Instant validTo;

    private HttpParameterInfo(HttpServletRequest httpRequest, LocaleUtils localeUtils) {
        this.httpRequest = httpRequest;
        this.localeUtils = localeUtils;
    }

    public static ParameterInfo fromRequest(HttpServletRequest httpRequest, CdsRuntime runtime) {
        return new HttpParameterInfo(httpRequest, new LocaleUtils(runtime.getEnvironment().getCdsProperties()));
    }

    public Map<String, String> getHeaders() {
        HashMap<String, String> result = new HashMap<String, String>();
        Enumeration headerKeys = this.httpRequest.getHeaderNames();
        if (headerKeys == null) {
            return result;
        }
        while (headerKeys.hasMoreElements()) {
            String headerKey = (String)headerKeys.nextElement();
            result.put(headerKey, this.getHeader(headerKey));
        }
        return result;
    }

    public String getHeader(String id) {
        Enumeration headerValues = this.httpRequest.getHeaders(id);
        if (headerValues == null || !headerValues.hasMoreElements()) {
            return null;
        }
        return Collections.list(headerValues).stream().collect(Collectors.joining(","));
    }

    public String getQueryParameter(String key) {
        String[] values = (String[])this.httpRequest.getParameterMap().get(key);
        if (values != null && values.length >= 1) {
            return values[0];
        }
        return null;
    }

    public Stream<String> getQueryParameters() {
        return this.httpRequest.getParameterMap().keySet().stream();
    }

    public Map<String, String> getQueryParams() {
        Map parametersMap = this.httpRequest.getParameterMap();
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry entry : parametersMap.entrySet()) {
            String[] values = (String[])entry.getValue();
            String valueString = values != null ? Arrays.asList(values).stream().collect(Collectors.joining(",")) : null;
            result.put((String)entry.getKey(), valueString);
        }
        return result;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = this.localeUtils.getLocale(this.getQueryParameter("sap-language"), this.getHeader("x-sap-request-language"), this.getHeader("Accept-Language"));
        }
        return this.locale;
    }

    public Instant getValidFrom() {
        if (this.validFrom == null) {
            this.initTemporalRange();
        }
        return this.validFrom;
    }

    public Instant getValidTo() {
        if (this.validTo == null) {
            this.initTemporalRange();
        }
        return this.validTo;
    }

    private void initTemporalRange() {
        Instant[] ranges = TemporalRangeUtils.getTemporalRanges(this.getQueryParameter("sap-valid-from"), this.getQueryParameter("sap-valid-to"), this.getQueryParameter("sap-valid-at"));
        this.validFrom = ranges[0];
        this.validTo = ranges[1];
    }
}

