/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils;

import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.draft.DraftService;
import com.sap.cds.services.mt.TenantProviderService;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.model.CdsAnnotations;
import java.util.List;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DraftUtils {
    private static final Logger log = LoggerFactory.getLogger(DraftUtils.class);

    public static boolean isDraftEnabled(String serviceName, CdsModel model) {
        return model.entities().anyMatch(e -> e.getQualifiedName().startsWith(serviceName) && DraftUtils.isDraftEnabled(e));
    }

    public static boolean isDraftEnabled(CdsEntity entity) {
        return CdsAnnotations.DRAFT_ANNOTATION.isTrue((CdsAnnotatable)entity) || CdsAnnotations.DRAFT_PREPARE_ANNOTATION.getOrDefault((CdsAnnotatable)entity) != null;
    }

    public static boolean isDraftEnabledNoChild(CdsEntity entity) {
        return CdsAnnotations.DRAFT_ANNOTATION.isTrue((CdsAnnotatable)entity);
    }

    public static void gcDraftsOfAllServices(CdsRuntime runtime) {
        Stream draftServices = runtime.getServiceCatalog().getServices(DraftService.class);
        draftServices.forEach(draftService -> draftService.gcDrafts());
    }

    public static void gcDraftsOfAllServicesAndTenants(CdsRuntime runtime) {
        TenantProviderService tenantProvider = (TenantProviderService)runtime.getServiceCatalog().getService(TenantProviderService.class, "TenantProviderService$Default");
        List tenants = tenantProvider.readTenants();
        tenants.forEach(tenant -> {
            try {
                runtime.requestContext().privilegedUser().modifyUser(user -> user.setTenant(tenant)).recalculateFeatureToggles().run(context -> DraftUtils.gcDraftsOfAllServices(runtime));
            }
            catch (Throwable t) {
                log.error("Failed to gc drafts of tenant '{}'", tenant, (Object)t);
            }
        });
    }
}

