/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ETagUtils {
    private static Logger log = LoggerFactory.getLogger(ETagUtils.class);
    private static final String NULL_ETAG = "W/\"\"";
    private static final String WEAK_PATTERN = "W/\"(.*)\"";
    private static final String STRONG_PATTERN = "\"(.*)\"";
    private static final Pattern strongPattern = Pattern.compile("\"(.*)\"");
    private static final Pattern weakPattern = Pattern.compile("W/\"(.*)\"");
    private static final String DELIMITER = ",";
    private static final String SPACE = "\\s*";

    public static String extractETagValue(String headerValue) {
        log.debug("Extracting eTag header value {}.", (Object)headerValue);
        Matcher weakMatcher = weakPattern.matcher(headerValue);
        Matcher strongMatcher = strongPattern.matcher(headerValue);
        if (weakMatcher.matches()) {
            return weakMatcher.group(1);
        }
        if (strongMatcher.matches()) {
            return strongMatcher.group(1);
        }
        return headerValue;
    }

    public static List<String> parseHeaderValues(List<String> headerValues) {
        List<String> headerValueList = new ArrayList<String>();
        if (headerValues != null) {
            headerValueList = headerValues.stream().map(ETagUtils::extractETagValue).collect(Collectors.toList());
        }
        return headerValueList.isEmpty() ? null : headerValueList;
    }

    public static String createETagHeaderValue(String propValue) {
        String eTag = NULL_ETAG;
        if (propValue != null) {
            eTag = "W/\"" + propValue + "\"";
        }
        return eTag;
    }

    public static List<String> parseHeader(String header) {
        ArrayList<String> headerValueList = new ArrayList<String>();
        if (header != null && !header.isEmpty()) {
            String[] arr = header.trim().split("\\s*,\\s*");
            headerValueList.addAll(ETagUtils.parseHeaderValues(Arrays.asList(arr)));
        }
        return headerValueList.isEmpty() ? null : headerValueList;
    }
}

