/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils;

import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.StringUtils;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;

public class TemporalRangeUtils {
    public static final Instant MIN_VALID_FROM = Instant.parse("0001-01-01T00:00:00Z");
    public static final Instant MAX_VALID_TO = Instant.parse("9999-12-31T23:59:59.999999999Z");

    public static Instant[] getTemporalRanges(Instant validAt) {
        Instant[] range;
        range = new Instant[]{validAt == null ? Instant.now() : validAt, range[0].plusMillis(1L)};
        return TemporalRangeUtils.truncatedRange(range);
    }

    public static Instant[] getTemporalRanges(String validFromQueryParam, String validToQueryParam, String validAtQueryParam) {
        Instant validFrom = TemporalRangeUtils.parseDate(validFromQueryParam, "sap-valid-from");
        Instant validTo = TemporalRangeUtils.parseDate(validToQueryParam, "sap-valid-to");
        if (validFrom == null && validTo == null) {
            Instant validAt = TemporalRangeUtils.parseDate(validAtQueryParam, "sap-valid-at");
            return TemporalRangeUtils.getTemporalRanges(validAt);
        }
        if (validFrom == null) {
            validFrom = MIN_VALID_FROM;
        }
        if (validTo == null) {
            validTo = MAX_VALID_TO;
        }
        return TemporalRangeUtils.truncatedRange(new Instant[]{validFrom, validTo});
    }

    private static Instant parseDate(String date, String hint) {
        if (!StringUtils.isEmpty(date)) {
            try {
                return Instant.from(DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(date));
            }
            catch (DateTimeParseException e1) {
                try {
                    TemporalAccessor accessor = DateTimeFormatter.ISO_DATE.parse(date);
                    ZoneOffset zoneOffset = TemporalRangeUtils.getZoneOffset(accessor);
                    LocalTime time = TemporalRangeUtils.getLocalTime(hint);
                    LocalDateTime dateTime = LocalDate.from(accessor).atTime(time);
                    return dateTime.toInstant(zoneOffset);
                }
                catch (DateTimeParseException e2) {
                    try {
                        return Timestamp.valueOf(date).toLocalDateTime().toInstant(ZoneOffset.UTC);
                    }
                    catch (IllegalArgumentException e3) {
                        throw new ErrorStatusException(CdsErrorStatuses.INVALID_DATE_VALUE, hint, e1);
                    }
                }
            }
        }
        return null;
    }

    private static ZoneOffset getZoneOffset(TemporalAccessor accessor) {
        if (accessor.isSupported(ChronoField.OFFSET_SECONDS)) {
            return ZoneOffset.ofTotalSeconds(accessor.get(ChronoField.OFFSET_SECONDS));
        }
        return ZoneOffset.UTC;
    }

    private static LocalTime getLocalTime(String hint) {
        switch (hint) {
            default: {
                return LocalTime.MIN;
            }
            case "sap-valid-to": 
        }
        return LocalTime.MAX;
    }

    private static Instant[] truncatedRange(Instant[] range) {
        Instant[] truncatedRange = new Instant[range.length];
        for (int i = 0; i < range.length; ++i) {
            truncatedRange[i] = range[i].truncatedTo(ChronoUnit.MICROS);
        }
        return truncatedRange;
    }
}

