/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils;

import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.runtime.CdsRuntime;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class TenantAwareCache<T, V> {
    private final Supplier<String> tenantSupplier;
    private final Supplier<T> valueSupplier;
    private final Supplier<V> validatorSupplier;
    private final Map<String, CacheEntry<T, V>> cached = new ConcurrentHashMap<String, CacheEntry<T, V>>();

    public static <T> TenantAwareCache<T, CdsModel> create(Supplier<T> valueSupplier, CdsRuntime runtime) {
        Supplier<String> tenantSupplier = () -> RequestContext.isActive() ? RequestContext.getCurrent((CdsRuntime)runtime).getUserInfo().getTenant() : runtime.getProvidedUserInfo().getTenant();
        return new TenantAwareCache<T, CdsModel>(tenantSupplier, valueSupplier, () -> RequestContext.getCurrent((CdsRuntime)runtime).getModel());
    }

    public static <T, V> TenantAwareCache<T, V> create(Supplier<String> tenantSupplier, Supplier<T> valueSupplier, Supplier<V> validatorSupplier) {
        return new TenantAwareCache<T, V>(tenantSupplier, valueSupplier, validatorSupplier);
    }

    private TenantAwareCache(Supplier<String> tenantSupplier, Supplier<T> valueSupplier, Supplier<V> validatorSupplier) {
        this.tenantSupplier = tenantSupplier;
        this.valueSupplier = valueSupplier;
        this.validatorSupplier = validatorSupplier;
    }

    public T findOrCreate() {
        T newValue;
        CacheEntry<T, V> newEntry;
        String tenantName = this.tenantSupplier.get();
        String tenantKey = tenantName == null ? "" : tenantName.trim();
        V validator = this.validatorSupplier.get();
        CacheEntry<T, V> entry = this.cached.get(tenantKey);
        if (entry != null && !Objects.equals(validator, ((CacheEntry)entry).validator)) {
            this.cached.remove(tenantKey);
            entry = null;
        }
        if (entry == null && (entry = this.cached.putIfAbsent(tenantKey, newEntry = new CacheEntry<T, V>(newValue = this.valueSupplier.get(), validator))) == null) {
            entry = newEntry;
        }
        return (T)((CacheEntry)entry).value;
    }

    private static class CacheEntry<T, V> {
        private final T value;
        private final V validator;

        public CacheEntry(T value, V validator) {
            this.value = value;
            this.validator = validator;
        }
    }
}

